/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.factory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.n2oapp.engine.factory.EngineNotFoundException;
import net.n2oapp.engine.factory.EngineNotUniqueException;
import net.n2oapp.engine.factory.locator.EngineLocator;
import net.n2oapp.engine.factory.locator.SimpleEngineLocator;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.factory.MetadataFactory;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.config.factory.AwareFactorySupport;

public abstract class BaseMetadataFactory<G>
implements MetadataFactory<G>,
MetadataEnvironmentAware {
    private MetadataEnvironment environment;
    private SimpleEngineLocator<G> locator;

    public BaseMetadataFactory() {
        this.locator = new SimpleEngineLocator(new HashMap());
    }

    public BaseMetadataFactory(Map<String, G> beans) {
        this.locator = new SimpleEngineLocator(beans);
    }

    public <T> G produce(BiPredicate<G, T> predicate, T target) {
        Object engine = null;
        try {
            engine = this.getLocator().locate(predicate).produce(target);
        }
        catch (EngineNotFoundException e) {
            throw new EngineNotFoundException(this.getClass(), e.getType());
        }
        catch (EngineNotUniqueException e) {
            throw new EngineNotUniqueException(this.getClass(), e.getType());
        }
        this.enrich(engine);
        return (G)engine;
    }

    public <T> List<G> produceList(BiPredicate<G, T> predicate, T target) {
        List engines = this.getLocator().locate(predicate).produceList(target);
        engines.forEach(this::enrich);
        return engines;
    }

    public MetadataFactory<G> add(G ... g) {
        for (G engine : g) {
            this.locator.add(engine);
        }
        return this;
    }

    protected EngineLocator<G> getLocator() {
        return this.locator;
    }

    protected void enrich(G engine) {
        AwareFactorySupport.enrich(engine, this.environment);
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.environment = environment;
    }
}

