/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.compile.pipeline.operation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.function.Supplier;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.aware.PipelineOperationTypeAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperation;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperationType;

public class SerializeOperation<S extends SourceMetadata>
implements PipelineOperation<InputStream, S>,
PipelineOperationTypeAware,
MetadataEnvironmentAware {
    private ObjectMapper mapper;

    public SerializeOperation() {
    }

    public SerializeOperation(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public InputStream execute(CompileContext<?, ?> context, DataSet data, Supplier<S> supplier, CompileProcessor compileProcessor, BindProcessor bindProcessor, SourceProcessor sourceProcessor) {
        byte[] buf;
        SourceMetadata value = (SourceMetadata)supplier.get();
        try {
            buf = this.mapper.writeValueAsBytes((Object)value);
        }
        catch (JsonProcessingException e) {
            throw new N2oException("Error during serialize metadata " + value.getId(), (Throwable)e);
        }
        return new ByteArrayInputStream(buf);
    }

    public PipelineOperationType getPipelineOperationType() {
        return PipelineOperationType.SERIALIZE;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.mapper = environment.getSerializeObjectMapper();
    }
}

