/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.websocket;

import java.util.Map;
import net.n2oapp.framework.autotest.websocket.BadgeColorEnum;
import net.n2oapp.framework.autotest.websocket.BadgeMessage;
import net.n2oapp.framework.boot.stomp.WebSocketController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.simp.SimpMessagingTemplate;

public class WebSocketMessageController {
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    @Autowired
    private WebSocketController wsController;
    @Value(value="${n2o.stomp.user-id}")
    private String userId;

    public void sendCount(String destination, Integer count) {
        BadgeMessage message = new BadgeMessage();
        message.setCount(count);
        this.messagingTemplate.convertAndSendToUser(this.userId, destination, (Object)message);
    }

    public void sendColor(String destination, BadgeColorEnum color) {
        BadgeMessage message = new BadgeMessage();
        message.setColor(color.toString());
        this.messagingTemplate.convertAndSendToUser(this.userId, destination, (Object)message);
    }

    public void sendAlert(String destination, Map<String, String> message) {
        this.wsController.convertAndSendToUser(this.userId, destination, message);
    }
}

