/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.widget.table;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.widget.table.TableHeader;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public abstract class N2oTableHeader
extends N2oComponent
implements TableHeader {
    @Override
    public void shouldHaveTitle(String title, Duration ... duration) {
        this.should(Condition.text((String)title), duration);
    }

    @Override
    public void shouldNotHaveTitle() {
        this.element().shouldBe(new WebElementCondition[]{Condition.empty});
    }

    @Override
    public void click() {
        SelenideElement elm = this.element().$(".checkbox-cell .n2o-checkbox .custom-control-label");
        if (elm.exists()) {
            elm.click();
        } else {
            this.element().$("button").should(new WebElementCondition[]{Condition.exist}).click();
        }
    }

    @Override
    public void shouldNotBeSorted() {
        this.sortingIcon().shouldNot(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldBeSortedByAsc() {
        this.sortingIcon().should(new WebElementCondition[]{Condition.exist, Condition.cssClass((String)"fa-sort-amount-asc")});
    }

    @Override
    public void shouldBeSortedByDesc() {
        this.sortingIcon().should(new WebElementCondition[]{Condition.exist, Condition.cssClass((String)"fa-sort-amount-desc")});
    }

    @Override
    public void shouldHaveAlignment(String alignment) {
        this.element().shouldHave(new WebElementCondition[]{Condition.attribute((String)"align", (String)alignment)});
    }

    @Override
    public void shouldHaveIcon(String icon) {
        this.icon().shouldHave(new WebElementCondition[]{Condition.cssClass((String)icon)});
    }

    @Override
    public void shouldNotHaveIcon() {
        this.icon().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    protected SelenideElement icon() {
        return this.element().$(".n2o-icon");
    }

    protected SelenideElement sortingIcon() {
        return this.element().$(".n2o-sorting-icon");
    }
}

