/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.fieldset;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.fieldset.MultiFieldSet;
import net.n2oapp.framework.autotest.api.component.fieldset.MultiFieldSetItem;
import net.n2oapp.framework.autotest.impl.component.fieldset.N2oFieldSet;

public class N2oMultiFieldSet
extends N2oFieldSet
implements MultiFieldSet {
    @Override
    public void shouldHaveLabel(String label, Duration ... duration) {
        this.should(Condition.text((String)label), this.label(), duration);
    }

    @Override
    public void shouldNotHaveLabel() {
        this.label().shouldNot(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveItems(int count) {
        this.items().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)count)});
    }

    @Override
    public void shouldBeEmpty() {
        this.shouldHaveItems(0);
    }

    @Override
    public MultiFieldSetItem item(int index) {
        return N2oSelenide.component(this.items().get(index), MultiFieldSetItem.class);
    }

    @Override
    public void shouldHaveAddButton() {
        this.addButton().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotHaveAddButton() {
        this.addButton().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void addButtonShouldBeEnabled() {
        this.addButton().shouldBe(new WebElementCondition[]{Condition.enabled});
    }

    @Override
    public void addButtonShouldBeDisabled() {
        this.addButton().shouldBe(new WebElementCondition[]{Condition.disabled});
    }

    @Override
    public void addButtonShouldHaveLabel(String label, Duration ... duration) {
        this.should(Condition.text((String)label), this.addButton(), duration);
    }

    @Override
    public void clickAddButton() {
        this.addButton().click();
    }

    @Override
    public void clickAddButton(String label) {
        this.addButton(label).click();
    }

    @Override
    public void shouldHaveRemoveAllButton() {
        this.removeAllButton().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotHaveRemoveAllButton() {
        this.removeAllButton().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void removeAllButtonShouldHaveLabel(String label, Duration ... duration) {
        this.should(Condition.text((String)label), this.removeAllButton(), duration);
    }

    @Override
    public void clickRemoveAllButton() {
        this.removeAllButton().click();
    }

    protected SelenideElement label() {
        return this.element().$(".n2o-fieldset__label");
    }

    protected SelenideElement addButton() {
        return this.innerElement().$(".n2o-multi-fieldset__add.btn");
    }

    protected SelenideElement addButton(String label) {
        return this.innerElement().$$(".n2o-multi-fieldset__add.btn").find(Condition.text((String)label));
    }

    protected SelenideElement removeAllButton() {
        return this.innerElement().$(".n2o-multi-fieldset__remove-all.btn");
    }

    protected ElementsCollection items() {
        return this.innerElement().$$(".n2o-multi-fieldset__item");
    }

    protected SelenideElement innerElement() {
        return super.element().$(".n2o-multi-fieldset");
    }
}

