/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.field;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.collection.Toolbar;
import net.n2oapp.framework.autotest.api.component.control.Control;
import net.n2oapp.framework.autotest.api.component.field.StandardField;
import net.n2oapp.framework.autotest.impl.collection.N2oToolbar;
import net.n2oapp.framework.autotest.impl.component.field.N2oField;

public class N2oStandardField
extends N2oField
implements StandardField {
    static final String CSS_SELECTOR = ".form-control, .n2o-input, .n2o-date-picker, .n2o-radio-group, .n2o-checkbox-group, .n2o-file-uploader-control, .n2o-image-uploader-control, .n2o-code-editor, .n2o-html, .n2o-output-text, .n2o-output-list, .n2o-pill-filter, .n2o-rating-stars, .n2o-slider, .n2o-text-editor, .progress, .n2o-number-picker, .n2o-select-tree";

    @Override
    public <T extends Control> T control(Class<T> componentClass) {
        return (T)((Control)N2oSelenide.component(this.element().$(CSS_SELECTOR), componentClass));
    }

    @Override
    public Toolbar toolbar() {
        return N2oSelenide.collection(this.element().$$(".btn-toolbar .btn"), N2oToolbar.class);
    }

    @Override
    public void shouldBeRequired() {
        this.requiredLabel().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotBeRequired() {
        this.requiredLabel().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveLabelBy(WebElementCondition condition, Duration ... duration) {
        this.should(condition, this.element().$("label"), duration);
    }

    @Override
    public void shouldHaveLabelLocation(FieldSet.LabelPositionEnum position) {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)String.format("label-%s", position.getId()))});
    }

    @Override
    public void shouldHaveValidationMessage(WebElementCondition condition, Duration ... duration) {
        this.should(condition, this.element().$(".n2o-validation-message"), duration);
    }

    @Override
    public void shouldHaveDescription(String text) {
        this.element().shouldHave(new WebElementCondition[]{Condition.text((String)text)});
    }

    protected SelenideElement requiredLabel() {
        return this.element().$(".n2o-field-label-required");
    }
}

