/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.Slider;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oSlider
extends N2oControl
implements Slider {
    @Override
    public void shouldBeEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(String value) {
        this.setValue(this.sliderElement(0), value, 1);
    }

    @Override
    public void setValue(String value, int step) {
        this.setValue(this.sliderElement(0), value, step);
    }

    @Override
    public void setLeftValue(String value) {
        this.setValue(value);
    }

    @Override
    public void setLeftValue(String value, int step) {
        this.setValue(value, step);
    }

    @Override
    public void setRightValue(String value) {
        this.setValue(this.sliderElement(1), value, 1);
    }

    @Override
    public void setRightValue(String value, int step) {
        this.setValue(this.sliderElement(1), value, step);
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        this.shouldHaveValue(this.sliderElement(0), value);
    }

    @Override
    public void shouldHaveLeftValue(String value) {
        this.shouldHaveValue(value, new Duration[0]);
    }

    @Override
    public void shouldHaveRightValue(String value) {
        this.shouldHaveValue(this.sliderElement(1), value);
    }

    @Override
    public void shouldBeDisabled() {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"rc-slider-disabled")});
    }

    private void shouldHaveValue(SelenideElement element, String value) {
        element.shouldHave(new WebElementCondition[]{Condition.attribute((String)"aria-valuenow", (String)value)});
    }

    protected SelenideElement sliderElement(int index) {
        return this.element().$$(".rc-slider-handle").get(index).shouldHave(new WebElementCondition[]{Condition.exist});
    }

    private void setValue(SelenideElement element, String value, int step) {
        String current = element.getAttribute("aria-valuenow");
        int dif = (Integer.parseInt(current) - Integer.parseInt(value)) / step;
        Keys keys = dif > 0 ? Keys.ARROW_LEFT : Keys.ARROW_RIGHT;
        element.click();
        for (int i = 0; i < Math.abs(dif); ++i) {
            element.sendKeys(new CharSequence[]{keys});
        }
    }
}

