/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.ColorsEnum;
import net.n2oapp.framework.autotest.api.component.control.Progress;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oProgress
extends N2oControl
implements Progress {
    @Override
    public void shouldBeEmpty() {
        this.progressBar().shouldNot(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        this.progressBar().shouldHave(new WebElementCondition[]{Condition.attribute((String)"aria-valuenow", (String)value)});
    }

    @Override
    public void shouldHaveText(String text) {
        this.element().shouldHave(new WebElementCondition[]{Condition.attribute((String)"barText", (String)text)});
    }

    @Override
    public void shouldHaveMax(String max) {
        this.progressBar().shouldHave(new WebElementCondition[]{Condition.attribute((String)"aria-valuemax", (String)max)});
    }

    @Override
    public void shouldBeAnimated() {
        this.progressBar().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"progress-bar-animated")});
    }

    @Override
    public void shouldBeStriped() {
        this.progressBar().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"progress-bar-striped")});
    }

    @Override
    public void shouldHaveColor(ColorsEnum color) {
        this.progressBar().shouldHave(new WebElementCondition[]{Condition.cssClass((String)color.name("bg-"))});
    }

    protected SelenideElement progressBar() {
        return this.element().$(".progress-bar");
    }
}

