/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.PasswordControl;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oPasswordControl
extends N2oControl
implements PasswordControl {
    @Override
    public String getValue() {
        SelenideElement input = this.inputElement();
        return input.exists() ? input.getValue() : this.cellInputElement().text();
    }

    @Override
    public void setValue(String value) {
        this.inputElement().setValue(value).pressEnter();
    }

    @Override
    public void shouldBeEmpty() {
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            input.shouldHave(new WebElementCondition[]{Condition.empty});
        } else {
            this.cellInputElement().shouldHave(new WebElementCondition[]{Condition.empty});
        }
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        boolean logicResult;
        SelenideElement input = this.inputElement();
        boolean bl = logicResult = value == null || value.isEmpty();
        if (input.exists()) {
            this.should(logicResult ? Condition.empty : Condition.value((String)value), input, duration);
        } else {
            this.should(logicResult ? Condition.empty : Condition.text((String)value), this.cellInputElement(), duration);
        }
    }

    @Override
    public void shouldHavePlaceholder(String value) {
        WebElementCondition condition = Condition.attribute((String)"placeholder", (String)value);
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            input.shouldHave(new WebElementCondition[]{condition});
        } else {
            this.cellInputElement().shouldHave(new WebElementCondition[]{condition});
        }
    }

    @Override
    public void clickEyeButton() {
        this.element().parent().$(".n2o-input-password-toggler").hover().shouldBe(new WebElementCondition[]{Condition.visible}).click();
    }

    @Override
    public void shouldHaveVisiblePassword() {
        SelenideElement input = this.inputElement();
        WebElementCondition condition = Condition.attribute((String)"type", (String)"text");
        if (input.exists()) {
            input.shouldHave(new WebElementCondition[]{condition});
        } else {
            this.cellInputElement().shouldHave(new WebElementCondition[]{condition});
        }
    }

    @Override
    public void shouldNotHaveVisiblePassword() {
        SelenideElement input = this.inputElement();
        WebElementCondition condition = Condition.attribute((String)"type", (String)"password");
        if (input.exists()) {
            input.shouldHave(new WebElementCondition[]{condition});
        } else {
            this.cellInputElement().shouldHave(new WebElementCondition[]{condition});
        }
    }

    protected SelenideElement inputElement() {
        return this.element().shouldBe(new WebElementCondition[]{Condition.exist}).parent().$(".n2o-input");
    }

    protected SelenideElement cellInputElement() {
        return this.element().$(".n2o-editable-cell .n2o-editable-cell-text");
    }
}

