/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.MaskedInput;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oMaskedInput
extends N2oControl
implements MaskedInput {
    @Override
    public void shouldBeEmpty() {
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            this.inputElement().shouldBe(new WebElementCondition[]{Condition.empty});
        } else {
            this.cellInputElement().shouldBe(new WebElementCondition[]{Condition.empty});
        }
    }

    @Override
    public String getValue() {
        SelenideElement input = this.inputElement();
        return input.exists() ? input.getValue() : this.cellInputElement().text();
    }

    @Override
    public void setValue(String value) {
        this.inputElement().setValue(value).pressEnter();
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            this.should(Condition.value((String)value), input, duration);
        } else {
            this.should(Condition.text((String)value), this.cellInputElement(), duration);
        }
    }

    @Override
    public void shouldHavePlaceholder(String value) {
        WebElementCondition condition = Condition.attribute((String)"placeholder", (String)value);
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            input.shouldHave(new WebElementCondition[]{condition});
        } else {
            this.cellInputElement().shouldHave(new WebElementCondition[]{condition});
        }
    }

    @Override
    public void shouldHaveMeasure() {
        this.inputMeasure().should(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveMeasureText(String text) {
        this.inputMeasure().shouldHave(new WebElementCondition[]{Condition.text((String)text)});
    }

    protected SelenideElement inputElement() {
        return this.element().shouldBe(new WebElementCondition[]{Condition.exist}).parent().$(".n2o-input-mask");
    }

    protected SelenideElement cellInputElement() {
        return this.element().$(".n2o-editable-cell .n2o-editable-cell-text");
    }

    protected SelenideElement inputMeasure() {
        return this.element().parent().$(".n2o-control-container-placeholder");
    }
}

