/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.DropDownTree;
import net.n2oapp.framework.autotest.api.component.control.InputSelectTree;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oInputSelectTree
extends N2oControl
implements InputSelectTree {
    private static final String OPTION_LOCATOR = ".n2o-select-tree-tree-list .n2o-select-tree-tree-treenode";

    @Override
    public void shouldBeEmpty() {
        this.inputElement().shouldBe(new WebElementCondition[]{Condition.empty});
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        this.should(Condition.text((String)value), this.selectedItems().get(0), duration);
    }

    @Override
    public void shouldHavePlaceholder(String value) {
        this.element().$(".n2o-select-tree-selection-placeholder").shouldHave(new WebElementCondition[]{Condition.text((String)value)});
    }

    @Override
    public void click() {
        this.element().hover().shouldBe(new WebElementCondition[]{Condition.visible}).click();
    }

    @Override
    public void expandParentOptions(int parentIndex) {
        this.dropdownElement().$$(String.format("%s i", OPTION_LOCATOR)).get(parentIndex).click();
    }

    @Override
    public void setFilter(String value) {
        this.inputElement().setValue(value);
    }

    @Override
    public void shouldSelectedMulti(String[] values, Duration ... duration) {
        if (values.length != 0) {
            this.should(CollectionCondition.size((int)values.length), this.selectedItems(), duration);
            this.should(CollectionCondition.textsInAnyOrder((String[])values), this.selectedItems(), duration);
        }
    }

    @Override
    public void shouldSelectedMultiSize(int size) {
        this.selectedItems().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)size)});
    }

    @Override
    public void clearSearchField() {
        this.inputElement().clear();
    }

    @Override
    public void shouldDisplayedOptions(WebElementsCondition condition) {
        this.dropdownElement().$$(OPTION_LOCATOR).shouldHave(new WebElementsCondition[]{condition});
    }

    @Override
    public void selectOption(int index) {
        this.dropdownElement().$$(OPTION_LOCATOR).get(index).hover().shouldBe(new WebElementCondition[]{Condition.visible}).click();
    }

    @Override
    public void shouldBeSelected(int index, String value, Duration ... duration) {
        this.should(Condition.text((String)value), this.selectedElements().get(index), duration);
    }

    @Override
    public void removeOption(int index) {
        this.element().$$(".n2o-select-tree-selection-overflow-item").get(index).$(".n2o-select-tree-selection-item-remove").hover().shouldBe(new WebElementCondition[]{Condition.visible}).click();
    }

    @Override
    public void removeAllOptions() {
        this.element().$(".n2o-select-tree-clear").hover().shouldBe(new WebElementCondition[]{Condition.visible}).click();
    }

    @Override
    public void shouldBeUnselected() {
        this.selectedElements().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)0)});
    }

    @Override
    public DropDownTree dropdown() {
        return N2oSelenide.component(this.dropdownElement(), DropDownTree.class);
    }

    protected SelenideElement dropdownElement() {
        return this.element().$(".n2o-select-tree-dropdown");
    }

    @Override
    public void openPopup() {
        if (!this.isOpened()) {
            this.element().click();
        }
    }

    @Override
    public void closePopup() {
        if (this.isOpened()) {
            this.element().click();
        }
    }

    @Override
    public void shouldBeOpened() {
        this.dropdownElement().shouldBe(new WebElementCondition[]{Condition.visible});
    }

    @Override
    public void shouldBeClosed() {
        this.dropdownElement().shouldNotBe(new WebElementCondition[]{Condition.visible});
    }

    @Override
    public void shouldBeDisabled() {
        this.inputElement().shouldBe(new WebElementCondition[]{Condition.disabled});
    }

    protected SelenideElement switcher() {
        return this.element().$(".n2o-select-tree-arrow");
    }

    protected SelenideElement inputElement() {
        return this.element().$(".n2o-select-tree-selection-search-input");
    }

    protected ElementsCollection selectedElements() {
        return this.element().$$(".n2o-select-tree-tree-treenode-checkbox-checked");
    }

    private boolean isOpened() {
        return this.element().has(Condition.cssClass((String)".n2o-select-tree-open"));
    }

    protected ElementsCollection selectedItems() {
        return this.element().$$(".n2o-select-tree-selection-item");
    }

    @Override
    public void shouldHaveDropdownMessage(String value, Duration ... duration) {
        this.should(Condition.exactText((String)value), this.element().$(".n2o-select-tree-empty"), duration);
    }
}

