/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import java.util.stream.IntStream;
import net.n2oapp.framework.autotest.api.component.control.CodeEditor;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oCodeEditor
extends N2oControl
implements CodeEditor {
    @Override
    public void shouldBeEmpty() {
        ElementsCollection lines = this.lines();
        lines.shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)1)});
        lines.get(0).shouldBe(new WebElementCondition[]{Condition.empty});
    }

    @Override
    public void setValue(String value) {
        this.element().$("textarea").setValue(value);
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        String[] lines = value.trim().split("\n");
        IntStream.range(0, lines.length).forEach(i -> this.shouldHaveValue(lines[i], i, duration));
    }

    @Override
    public void shouldHaveValue(String value, int line, Duration ... duration) {
        this.should(Condition.text((String)value), this.lines().get(line), duration);
    }

    @Override
    public void shouldHaveLines(int lines) {
        this.lines().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)lines)});
    }

    @Override
    public void shouldHaveRowsInLine(int rows, int line) {
        this.lines().get(line).$$(".ace_line").shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)rows)});
    }

    @Override
    public void shouldBeDisabled() {
        this.element().$(".ace_text-input").shouldHave(new WebElementCondition[]{Condition.readonly});
    }

    protected ElementsCollection lines() {
        return this.element().$$(".ace_line_group");
    }
}

