/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.cell;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import java.util.Objects;
import net.n2oapp.framework.api.metadata.meta.badge.PositionEnum;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.Tooltip;
import net.n2oapp.framework.autotest.api.component.cell.TextCell;
import net.n2oapp.framework.autotest.impl.component.cell.N2oCell;

public class N2oTextCell
extends N2oCell
implements TextCell {
    @Override
    public void shouldHaveText(String text, Duration ... duration) {
        this.should(Condition.exactText((String)text), duration);
    }

    @Override
    public void shouldHaveSubText(String[] text, Duration ... duration) {
        this.should(CollectionCondition.texts((String[])text), this.element().$$(".text-muted"), duration);
    }

    @Override
    public void shouldHaveIconPosition(PositionEnum position) {
        SelenideElement iconContainer = this.element().$(".icon-cell-container");
        if (iconContainer.$(".n2o-icon").is(Condition.exist)) {
            if (Objects.requireNonNull(position) == PositionEnum.LEFT) {
                iconContainer.shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)"icon-cell-container__text-left")});
            } else if (position == PositionEnum.RIGHT) {
                iconContainer.shouldHave(new WebElementCondition[]{Condition.cssClass((String)"icon-cell-container__text-left")});
            }
        }
    }

    @Override
    public void hover() {
        this.element().$(".icon-cell-container").hover();
    }

    @Override
    public Tooltip tooltip() {
        SelenideElement element = this.element().parent().parent().parent().parent().$(".tooltip-container");
        return N2oSelenide.component(element, Tooltip.class);
    }
}

