/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.cell;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.cell.ListCell;
import net.n2oapp.framework.autotest.impl.component.cell.N2oCell;

public class N2oListCell
extends N2oCell
implements ListCell {
    @Override
    public void shouldHaveSize(int size) {
        this.badges().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)size)});
    }

    @Override
    public void shouldHaveInnerLinksSize(int size) {
        this.innerLinks().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)size)});
    }

    @Override
    public void shouldHaveInnerBadgesSize(int size) {
        this.innerBadges().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)size)});
    }

    @Override
    public void shouldHaveText(int index, String val, Duration ... duration) {
        this.should(Condition.text((String)val), this.badges().get(index), duration);
    }

    @Override
    public void shouldNotBeExpandable() {
        this.cellControl().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldBeExpandable() {
        this.cellControl().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void expand() {
        this.cellControl().click();
    }

    @Override
    public void shouldHaveInnerText(int index, String val, Duration ... duration) {
        this.should(Condition.text((String)val), this.innerTexts().get(index), duration);
    }

    @Override
    public void shouldHaveInnerLink(int index, String val, Duration ... duration) {
        this.should(Condition.text((String)val), this.innerLinks().get(index), duration);
    }

    @Override
    public void shouldHaveInnerBadge(int index, String val, Duration ... duration) {
        this.should(Condition.text((String)val), this.innerBadges().get(index), duration);
    }

    @Override
    public void shouldHaveSeparator(String val, Duration ... duration) {
        this.should(Condition.text((String)val), this.cellContent(), duration);
    }

    @Override
    public void shouldBeInline() {
        this.cellContentInline().should(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotBeInline() {
        this.cellContentInline().should(new WebElementCondition[]{Condition.not((WebElementCondition)Condition.exist)});
    }

    @Override
    public void shouldHaveHref(int index, String href) {
        this.innerLinks().get(index).shouldHave(new WebElementCondition[]{Condition.attribute((String)"href", (String)href)});
    }

    protected ElementsCollection badges() {
        return this.element().$$(".badge");
    }

    protected SelenideElement cellControl() {
        return this.element().$(".collapsed-cell-control");
    }

    protected SelenideElement cellContent() {
        return this.element().$(".collapse-cell-content");
    }

    protected SelenideElement cellContentInline() {
        return this.element().$(".collapse-cell-content--inline");
    }

    protected ElementsCollection innerTexts() {
        return this.element().$$(".icon-cell-container");
    }

    protected ElementsCollection innerLinks() {
        return this.element().$$(".n2o-link-cell");
    }

    protected ElementsCollection innerBadges() {
        return this.element().$$(".n2o-badge");
    }
}

