/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.cell;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ShapeTypeEnum;
import net.n2oapp.framework.api.metadata.meta.cell.ImageStatusElementPlaceEnum;
import net.n2oapp.framework.api.metadata.meta.control.TextPositionEnum;
import net.n2oapp.framework.autotest.api.component.cell.ImageCell;
import net.n2oapp.framework.autotest.impl.component.cell.N2oCell;

public class N2oImageCell
extends N2oCell
implements ImageCell {
    @Override
    public void shouldHaveSrc(String src) {
        this.img().shouldHave(new WebElementCondition[]{Condition.attribute((String)"src", (String)src)});
    }

    @Override
    public void shouldHaveWidth(int width) {
        this.img().parent().parent().shouldHave(new WebElementCondition[]{Condition.attributeMatching((String)"style", (String)String.format(".*max-width: %dpx;.*", width))});
    }

    @Override
    public void shouldHaveShape(ShapeTypeEnum shape) {
        SelenideElement imageContainer = this.img().parent().parent();
        switch (shape) {
            case CIRCLE: {
                imageContainer.shouldHave(new WebElementCondition[]{Condition.cssClass((String)"circle")});
                break;
            }
            case ROUNDED: {
                imageContainer.shouldHave(new WebElementCondition[]{Condition.cssClass((String)"rounded")});
                break;
            }
            case SQUARE: {
                imageContainer.shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)"circle"), Condition.cssClass((String)"rounded")});
            }
        }
    }

    @Override
    public void shouldHaveTitle(String title, Duration ... duration) {
        this.should(Condition.exactText((String)title), this.element().$(".n2o-image__info .n2o-image__info_label"), duration);
    }

    @Override
    public void shouldHaveDescription(String description, Duration ... duration) {
        this.should(Condition.exactText((String)description), this.element().$(".n2o-image__info .n2o-image__info_description"), duration);
    }

    @Override
    public void shouldHaveTextPosition(TextPositionEnum textPosition) {
        this.element().$(".n2o-image__content").shouldHave(new WebElementCondition[]{Condition.cssClass((String)textPosition.getId())});
    }

    @Override
    public void shouldHaveStatus(ImageStatusElementPlaceEnum position, int index, String title, Duration ... duration) {
        this.should(Condition.text((String)title), this.getStatus(position, index).$(".n2o-status__text"), duration);
    }

    @Override
    public void statusShouldHaveIcon(ImageStatusElementPlaceEnum position, int index, String icon) {
        if (icon != null && !icon.isEmpty()) {
            this.getStatus(position, index).$(String.format(".n2o-status__icon%s", icon)).should(new WebElementCondition[]{Condition.exist});
        }
    }

    protected SelenideElement getStatus(ImageStatusElementPlaceEnum position, int index) {
        return this.element().$$(String.format(".n2o-image-statuses .%s", position.getId())).get(index);
    }

    protected SelenideElement img() {
        return this.element().$("img");
    }
}

