/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.api.component.badge;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.BadgePositionEnum;
import net.n2oapp.framework.autotest.BadgeShapeEnum;
import net.n2oapp.framework.autotest.ColorsEnum;
import net.n2oapp.framework.autotest.api.component.Component;

public interface Badge
extends Component {
    default public void badgeShouldExists() {
        this.element().$(".n2o-badge").shouldBe(new WebElementCondition[]{Condition.exist});
    }

    default public void badgeShouldNotExists() {
        this.element().$(".n2o-badge").shouldNotBe(new WebElementCondition[]{Condition.visible});
    }

    default public void badgeShouldHaveImage(String imageSrc) {
        this.element().$(".n2o-badge").$(".n2o-badge-image").shouldBe(new WebElementCondition[]{Condition.exist, Condition.attributeMatching((String)"src", (String)(".*" + imageSrc))});
    }

    default public void badgeShouldHaveShape(BadgeShapeEnum shape) {
        this.element().$(".n2o-badge").shouldHave(new WebElementCondition[]{Condition.cssClass((String)shape.name("n2o-badge--"))});
    }

    default public void badgeShouldHavePosition(BadgePositionEnum position) {
        if (position.equals((Object)BadgePositionEnum.LEFT)) {
            this.element().$$("span").get(0).shouldHave(new WebElementCondition[]{Condition.cssClass((String)"badge")});
        } else {
            this.element().$$("span").get(1).shouldHave(new WebElementCondition[]{Condition.cssClass((String)"badge")});
        }
    }

    default public void badgeShouldHaveImageShape(BadgeShapeEnum shape) {
        this.element().$(".n2o-badge").$(".n2o-badge-image").shouldHave(new WebElementCondition[]{Condition.cssClass((String)shape.name("n2o-badge-image--"))});
    }

    default public void badgeShouldHaveImagePosition(BadgePositionEnum position) {
        this.element().$(".n2o-badge").$(".n2o-badge-image").shouldHave(new WebElementCondition[]{Condition.cssClass((String)position.name("n2o-badge-image--"))});
    }

    default public void badgeShouldHaveText(String text, Duration ... duration) {
        this.should(Condition.exactText((String)text), this.element().$(".n2o-badge"), duration);
    }

    default public void badgeShouldNotHaveText(Duration ... duration) {
        this.should(Condition.empty, this.element().$(".n2o-badge"), duration);
    }

    default public void badgeShouldHaveColor(ColorsEnum color) {
        this.element().$(".n2o-badge").shouldHave(new WebElementCondition[]{Condition.cssClass((String)String.format("badge-%s", color.name().toLowerCase()))});
    }
}

