/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.run;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class FileStoreController {
    private final List<FileModel> fileStore = Collections.synchronizedList(new ArrayList());

    public void clearFileStore() {
        this.fileStore.clear();
    }

    @PostMapping(value={"/files"})
    public ResponseEntity<FileModel> uploadFile(@RequestParam(value="file") MultipartFile file) throws IOException {
        return new ResponseEntity((Object)this.storeFile(file), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/multi"})
    public ResponseEntity<List<FileModel>> uploadMultiFile(@RequestParam(value="file") MultipartFile[] file) throws IOException {
        ArrayList<FileModel> result = new ArrayList<FileModel>();
        for (MultipartFile mf : file) {
            result.add(this.storeFile(mf));
        }
        return new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/files/{id}"})
    public void deleteFile(@PathVariable(value="id") String id) {
        for (FileModel fs : this.fileStore) {
            if (!id.equals(fs.id)) continue;
            this.fileStore.remove(fs);
            break;
        }
    }

    public ListResponse getList() {
        return new ListResponse(this.fileStore);
    }

    private FileModel storeFile(MultipartFile file) throws IOException {
        FileModel fm = FileModel.builder().id(UUID.randomUUID().toString()).fileName(file.getOriginalFilename()).url("/files/" + file.getOriginalFilename()).size(file.getSize()).build();
        byte[] cont = file.getBytes();
        MatcherAssert.assertThat((Object)(file.getSize() - (long)cont.length), (Matcher)CoreMatchers.is((Object)0L));
        this.fileStore.add(fm);
        return fm;
    }

    @Generated
    public List<FileModel> getFileStore() {
        return this.fileStore;
    }

    public static class FileModel {
        String id;
        String fileName;
        String url;
        long size;

        @Generated
        FileModel(String id, String fileName, String url, long size) {
            this.id = id;
            this.fileName = fileName;
            this.url = url;
            this.size = size;
        }

        @Generated
        public static FileModelBuilder builder() {
            return new FileModelBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getFileName() {
            return this.fileName;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public long getSize() {
            return this.size;
        }

        @Generated
        public static class FileModelBuilder {
            @Generated
            private String id;
            @Generated
            private String fileName;
            @Generated
            private String url;
            @Generated
            private long size;

            @Generated
            FileModelBuilder() {
            }

            @Generated
            public FileModelBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public FileModelBuilder fileName(String fileName) {
                this.fileName = fileName;
                return this;
            }

            @Generated
            public FileModelBuilder url(String url) {
                this.url = url;
                return this;
            }

            @Generated
            public FileModelBuilder size(long size) {
                this.size = size;
                return this;
            }

            @Generated
            public FileModel build() {
                return new FileModel(this.id, this.fileName, this.url, this.size);
            }

            @Generated
            public String toString() {
                return "FileStoreController.FileModel.FileModelBuilder(id=" + this.id + ", fileName=" + this.fileName + ", url=" + this.url + ", size=" + this.size + ")";
            }
        }
    }

    static class ListResponse {
        @JsonProperty
        final Collection<FileModel> files;

        @Generated
        public Collection<FileModel> getFiles() {
            return this.files;
        }

        @Generated
        public ListResponse(Collection<FileModel> files) {
            this.files = files;
        }
    }
}

