/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.run;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLogger;
import io.qameta.allure.selenide.AllureSelenide;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.compile.SourceTransformer;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.page.Page;
import net.n2oapp.framework.autotest.run.AutoTestApplication;
import net.n2oapp.framework.autotest.run.AutoTestUtil;
import net.n2oapp.framework.autotest.run.N2oController;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.metadata.compile.query.TestEngineQueryTransformer;
import net.n2oapp.framework.config.selective.CompileInfo;
import net.n2oapp.framework.config.test.N2oTestBase;
import net.n2oapp.framework.config.test.SimplePropertyResolver;
import net.n2oapp.framework.engine.data.json.TestDataProviderEngine;
import net.n2oapp.properties.OverrideProperties;
import net.n2oapp.properties.reader.PropertiesReader;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.CollectionUtils;

@SpringBootTest(classes={AutoTestApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class AutoTestBase
extends N2oTestBase {
    @LocalServerPort
    protected int port;
    protected Logs logs;
    @Autowired
    private TestDataProviderEngine provider;
    private N2oController n2oController;

    public static void configureSelenide() {
        AutoTestUtil.checkChromeDriver();
        SelenideLogger.addListener((String)"AllureSelenide", (LogEventListener)new AllureSelenide());
        System.setProperty("chromeoptions.args", "--disable-dev-shm-usage,--no-sandbox,--verbose,--whitelisted-ips=''");
        System.setProperty("selenide.timeout", "20000");
        Configuration.headless = Boolean.parseBoolean(System.getProperty("selenide.headless", "true"));
        DesiredCapabilities capabilities = new DesiredCapabilities();
        ChromeOptions options = new ChromeOptions();
        LoggingPreferences loggingPreferences = new LoggingPreferences();
        loggingPreferences.enable("browser", Level.ALL);
        capabilities.setCapability("goog:loggingPrefs", (Object)loggingPreferences);
        capabilities.setCapability("goog:chromeOptions", (Object)options);
        capabilities.setCapability("unhandledPromptBehavior", (Object)UnexpectedAlertBehaviour.DISMISS);
        Configuration.browserCapabilities = capabilities;
    }

    public void setUp() {
        super.setUp();
        this.n2oController.setUp(this.builder);
    }

    @Autowired
    public void setN2oController(N2oController n2oController) {
        this.n2oController = n2oController;
    }

    @AfterEach
    void outputBrowserLog() {
        if (Objects.isNull(this.logs)) {
            return;
        }
        for (LogEntry log : this.logs.get("browser")) {
            if (log.getLevel() != Level.SEVERE) continue;
            System.out.println("BROWSER LOG: " + String.valueOf(log.getLevel()) + " " + log.getMessage());
        }
    }

    @AfterAll
    static void tearDown() {
        Selenide.closeWebDriver();
    }

    protected void configure(N2oApplicationBuilder builder) {
        super.configure(builder);
        builder.transformers(new SourceTransformer[]{new TestEngineQueryTransformer()});
        builder.sources(new SourceInfo[]{new CompileInfo("net/n2oapp/framework/config/default/default.application.xml")});
    }

    protected String getBaseUrl() {
        return "http://localhost:" + this.port;
    }

    protected <T extends Page> T open(Class<T> clazz) {
        T open = N2oSelenide.open(this.getBaseUrl(), clazz);
        this.logs = WebDriverRunner.getWebDriver().manage().logs();
        return open;
    }

    protected <T extends Page> T open(Class<T> clazz, String pageUrl, Map<String, String> queryParams) {
        if (pageUrl == null) {
            pageUrl = "/";
        }
        if (queryParams != null && !queryParams.isEmpty()) {
            pageUrl = (String)pageUrl + "?" + queryParams.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        }
        return N2oSelenide.open(this.getBaseUrl() + "/#" + (String)pageUrl, clazz);
    }

    protected void setUserInfo(Map<String, Object> user) {
        this.n2oController.addConfigProperty("user", user);
    }

    protected void setResourcePath(String classpath) {
        this.provider.setClasspathResourcePath(classpath);
        this.resolveIndividualProperties(classpath);
    }

    private void resolveIndividualProperties(String classpath) {
        String locationPattern = (String)(classpath.endsWith("/") ? classpath : classpath + "/") + "application.properties";
        if (!new DefaultResourceLoader().getResource(locationPattern).isReadable()) {
            return;
        }
        OverrideProperties overriddenProperties = PropertiesReader.getPropertiesFromURI((String)locationPattern);
        if (!CollectionUtils.isEmpty((Map)overriddenProperties)) {
            overriddenProperties.forEach((k, v) -> ((SimplePropertyResolver)this.builder.getEnvironment().getSystemProperties()).setProperty((String)k, v));
        }
    }
}

