/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.region;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import java.util.Objects;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.region.RegionItems;
import net.n2oapp.framework.autotest.api.component.region.ScrollspyRegion;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;
import net.n2oapp.framework.autotest.impl.component.region.N2oRegion;

public class N2oScrollspyRegion
extends N2oRegion
implements ScrollspyRegion {
    private static final String MENU_WRAPPER_CLASS = ".n2o-scroll-spy-region__menu-wrapper";

    @Override
    public ScrollspyRegion.ContentItem contentItem(int index) {
        return new N2oContentItem(this.contentItems().get(index));
    }

    @Override
    public ScrollspyRegion.ContentItem contentItem(String title) {
        return new N2oContentItem(this.contentItems().findBy(Condition.text((String)title)));
    }

    @Override
    public ScrollspyRegion.Menu menu() {
        return new N2oMenu(this.element().$(MENU_WRAPPER_CLASS));
    }

    @Override
    public void activeContentItemShouldHaveTitle(String title, Duration ... duration) {
        this.should(Condition.text((String)title), this.contentItems().findBy(Condition.cssClass((String)"active")), duration);
    }

    @Override
    public void activeMenuItemShouldHaveTitle(String title, Duration ... duration) {
        this.should(Condition.text((String)title), this.menu().element().$(".n2o-scroll-spy-region__menu-item.active"), duration);
    }

    @Override
    public void menuShouldHavePosition(ScrollspyRegion.MenuPositionEnum position) {
        SelenideElement element = this.element().parent().$(".position-right");
        if (Objects.requireNonNull(position) == ScrollspyRegion.MenuPositionEnum.LEFT) {
            element.shouldNotBe(new WebElementCondition[]{Condition.exist});
        } else if (position == ScrollspyRegion.MenuPositionEnum.RIGHT) {
            element.shouldHave(new WebElementCondition[]{Condition.exist});
        }
    }

    protected ElementsCollection contentItems() {
        return this.element().$$(".n2o-scroll-spy-region__content-wrapper");
    }

    public static class N2oContentItem
    extends N2oRegion
    implements ScrollspyRegion.ContentItem {
        public N2oContentItem(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public RegionItems content() {
            return this.content("nested-content");
        }

        @Override
        public RegionItems content(String className) {
            return N2oSelenide.collection(this.firstLevelElements(".n2o-scroll-spy-region__content", "." + className), RegionItems.class);
        }

        @Override
        public void scrollDown() {
            this.element().scrollIntoView(false);
        }

        @Override
        public void scrollUp() {
            this.element().scrollIntoView(true);
        }
    }

    public static class N2oMenu
    extends N2oComponent
    implements ScrollspyRegion.Menu {
        public N2oMenu(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public void shouldHaveTitle(String title, Duration ... duration) {
            this.should(Condition.text((String)title), this.element().$(".n2o-scroll-spy-region__menu-title"), duration);
        }

        @Override
        public ScrollspyRegion.MenuItem menuItem(int index) {
            return new N2oMenuItem(this.menuItems().get(index));
        }

        @Override
        public ScrollspyRegion.MenuItem menuItem(String title) {
            return new N2oMenuItem(this.menuItems().findBy(Condition.text((String)title)));
        }

        @Override
        public ScrollspyRegion.DropdownMenuItem dropdownMenuItem(int index) {
            return new N2oDropdownMenuItem(this.dropdownItems().get(index));
        }

        @Override
        public ScrollspyRegion.DropdownMenuItem dropdownMenuItem(String label) {
            return new N2oDropdownMenuItem(this.dropdownItems().findBy(Condition.text((String)label)));
        }

        @Override
        public ScrollspyRegion.GroupItem group(int index) {
            return new N2oGroupItem(this.groups().get(index));
        }

        @Override
        public ScrollspyRegion.GroupItem group(String label) {
            return new N2oGroupItem(this.groups().findBy(Condition.text((String)label)));
        }

        protected ElementsCollection dropdownItems() {
            return this.element().$$(".n2o-scroll-spy-region__dropdown-menu-items-wrapper");
        }

        protected ElementsCollection menuItems() {
            return this.element().$$(".n2o-scroll-spy-region__menu-item");
        }

        protected ElementsCollection groups() {
            return this.element().$$(".n2o-scroll-spy-region__group-items");
        }
    }

    public static class N2oGroupItem
    extends N2oMenu
    implements ScrollspyRegion.GroupItem {
        public N2oGroupItem(SelenideElement element) {
            super(element);
        }

        @Override
        public void shouldHaveTitle(String text, Duration ... duration) {
            this.should(Condition.text((String)text), this.element().$(".n2o-scroll-spy-region__group-items-title"), duration);
        }

        @Override
        public void shouldHaveHeadline() {
            this.element().$(".n2o-scroll-spy-region__group-items-divider").should(new WebElementCondition[]{Condition.visible});
        }

        @Override
        public void shouldNotHaveHeadline() {
            this.element().$(".n2o-scroll-spy-region__group-items-divider").shouldNot(new WebElementCondition[]{Condition.exist});
        }
    }

    public static class N2oDropdownMenuItem
    extends N2oComponent
    implements ScrollspyRegion.DropdownMenuItem {
        public N2oDropdownMenuItem(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public void shouldHaveText(String text, Duration ... duration) {
            this.should(Condition.text((String)text), duration);
        }

        @Override
        public ScrollspyRegion.MenuItem menuItem(int index) {
            return new N2oMenuItem(this.items().get(index));
        }

        @Override
        public ScrollspyRegion.MenuItem menuItem(String title) {
            return new N2oMenuItem(this.items().findBy(Condition.text((String)title)));
        }

        @Override
        public void shouldBeExpand() {
            this.element().$(N2oScrollspyRegion.MENU_WRAPPER_CLASS).shouldHave(new WebElementCondition[]{Condition.cssClass((String)"visible")});
        }

        @Override
        public void shouldBeCollapse() {
            this.element().$(N2oScrollspyRegion.MENU_WRAPPER_CLASS).shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)"visible")});
        }

        @Override
        public void click() {
            this.element().$(".n2o-scroll-spy-region__dropdown-toggle").click();
        }

        protected ElementsCollection items() {
            return this.element().$$(".n2o-scroll-spy-region__menu-item");
        }
    }

    public static class N2oMenuItem
    extends N2oComponent
    implements ScrollspyRegion.MenuItem {
        public N2oMenuItem(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public void shouldHaveText(String text, Duration ... duration) {
            this.should(Condition.text((String)text), duration);
        }

        @Override
        public void click() {
            this.element().click();
        }
    }
}

