/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.region;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.ColorsEnum;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.region.PanelRegion;
import net.n2oapp.framework.autotest.api.component.region.RegionItems;
import net.n2oapp.framework.autotest.impl.component.region.N2oRegion;

public class N2oPanelRegion
extends N2oRegion
implements PanelRegion {
    @Override
    public RegionItems content() {
        return N2oSelenide.collection(this.firstLevelElements(".card-body", "div"), RegionItems.class);
    }

    @Override
    public void shouldHaveTitle(String title, Duration ... duration) {
        this.should(Condition.text((String)title), this.header(), duration);
    }

    @Override
    public void shouldNotHaveTitle() {
        this.header().shouldNot(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveFooterTitle(String footer, Duration ... duration) {
        this.should(Condition.text((String)footer), this.element().$(".card-footer"), duration);
    }

    @Override
    public void expand() {
        if (this.collapseToggleBtn().is(this.collapsedCondition())) {
            this.collapseToggleBtn().click();
        }
    }

    @Override
    public void collapse() {
        if (!this.collapseToggleBtn().is(this.collapsedCondition())) {
            this.collapseToggleBtn().click();
        }
    }

    @Override
    public void shouldBeCollapsible() {
        this.collapseToggleBtn().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotBeCollapsible() {
        this.collapseToggleBtn().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldBeExpanded() {
        this.collapseToggleBtn().shouldNotHave(new WebElementCondition[]{this.collapsedCondition()});
    }

    @Override
    public void shouldBeCollapsed() {
        this.collapseToggleBtn().shouldHave(new WebElementCondition[]{this.collapsedCondition()});
    }

    @Override
    public void shouldHaveBorderColor(ColorsEnum color) {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)color.name("border-"))});
    }

    @Override
    public void shouldHaveIcon(String icon) {
        this.element().$(".card-header .n2o-icon").shouldHave(new WebElementCondition[]{Condition.cssClass((String)icon)});
    }

    protected SelenideElement collapseToggleBtn() {
        return this.element().$("button.collapse-toggle");
    }

    private WebElementCondition collapsedCondition() {
        return Condition.cssClass((String)"collapse-toggle--up");
    }

    protected SelenideElement header() {
        return this.element().$(".card-header");
    }
}

