/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.fieldset;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.collection.Fields;
import net.n2oapp.framework.autotest.api.component.fieldset.LineFieldSet;
import net.n2oapp.framework.autotest.impl.component.fieldset.N2oFieldSet;

public class N2oLineFieldSet
extends N2oFieldSet
implements LineFieldSet {
    @Override
    public Fields fields() {
        return N2oSelenide.collection(this.element().$$(".n2o-form-group"), Fields.class);
    }

    @Override
    public void shouldBeEmpty() {
        this.content().shouldHave(new WebElementCondition[]{Condition.empty});
    }

    @Override
    public void shouldBeCollapsible() {
        this.header().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotBeCollapsible() {
        this.header().shouldNot(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveLabel(String label, Duration ... duration) {
        SelenideElement labelElement = this.header().exists() ? this.panelHeaderText() : this.fieldsetTitleText();
        this.should(Condition.text((String)label), labelElement, duration);
    }

    @Override
    public void shouldNotHaveLabel() {
        if (this.header().exists()) {
            this.panelHeaderText().shouldHave(new WebElementCondition[]{Condition.empty});
        } else {
            this.fieldsetTitleText().shouldNotBe(new WebElementCondition[]{Condition.exist});
        }
    }

    @Override
    public void expand() {
        if (!this.item().is(this.expandedContentCondition())) {
            this.header().click();
        }
    }

    @Override
    public void collapse() {
        if (this.item().is(this.expandedContentCondition())) {
            this.header().click();
        }
    }

    @Override
    public void shouldBeExpanded() {
        this.item().shouldBe(new WebElementCondition[]{this.expandedContentCondition()});
    }

    @Override
    public void shouldBeCollapsed() {
        this.item().shouldNotBe(new WebElementCondition[]{this.expandedContentCondition()});
    }

    protected SelenideElement header() {
        return this.element().$(".n2o-panel-header");
    }

    protected SelenideElement item() {
        return this.element().$(".rc-collapse-item");
    }

    protected SelenideElement content() {
        return this.element().$(".rc-collapse-content-box");
    }

    private WebElementCondition expandedContentCondition() {
        return Condition.cssClass((String)"rc-collapse-item-active");
    }

    protected SelenideElement fieldsetTitleText() {
        return this.element().$(".title-fieldset-text");
    }

    protected SelenideElement panelHeaderText() {
        return this.header().$(".n2o-panel-header-text");
    }
}

