/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.TimePicker;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oTimePicker
extends N2oControl
implements TimePicker {
    private static final String ACTIVE = "active";

    @Override
    public void shouldBeEmpty() {
        this.shouldHaveValue("", new Duration[0]);
    }

    @Override
    public void selectHoursMinutesSeconds(String hours, String minutes, String seconds) {
        this.openPopup();
        this.hoursItems().get(Integer.parseInt(hours)).click();
        this.minutesItems().get(Integer.parseInt(minutes)).click();
        this.secondsItems().get(Integer.parseInt(seconds)).click();
        this.closePopup();
    }

    @Override
    public void selectMinutesSeconds(String minutes, String seconds) {
        this.openPopup();
        this.minutesItems().get(Integer.parseInt(minutes)).click();
        this.secondsItems().get(Integer.parseInt(seconds)).click();
        this.closePopup();
    }

    @Override
    public void selectHours(String hours) {
        this.openPopup();
        this.hoursItems().get(Integer.parseInt(hours)).click();
        this.closePopup();
    }

    @Override
    public void selectMinutes(String minutes) {
        this.openPopup();
        this.minutesItems().get(Integer.parseInt(minutes)).click();
        this.closePopup();
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        this.element().$(".n2o-input").shouldHave(new WebElementCondition[]{Condition.attribute((String)"value", (String)value)});
    }

    @Override
    public void shouldSelectedHoursMinutesSeconds(String hours, String minutes, String seconds) {
        this.openPopup();
        this.hoursActiveItem().shouldHave(new WebElementCondition[]{Condition.text((String)hours)});
        this.minutesActiveItem().shouldHave(new WebElementCondition[]{Condition.text((String)minutes)});
        this.secondsActiveItem().shouldHave(new WebElementCondition[]{Condition.text((String)seconds)});
        this.closePopup();
    }

    @Override
    public void shouldSelectedHoursMinutes(String hours, String minutes) {
        this.openPopup();
        this.hoursActiveItem().shouldHave(new WebElementCondition[]{Condition.text((String)hours)});
        this.minutesActiveItem().shouldHave(new WebElementCondition[]{Condition.text((String)minutes)});
        this.closePopup();
    }

    @Override
    public void shouldSelectedHours(String hours) {
        this.openPopup();
        this.hoursActiveItem().shouldHave(new WebElementCondition[]{Condition.text((String)hours)});
        this.closePopup();
    }

    @Override
    public void shouldSelectedMinutes(String minutes) {
        this.openPopup();
        this.minutesActiveItem().shouldHave(new WebElementCondition[]{Condition.text((String)minutes)});
        this.closePopup();
    }

    @Override
    public void shouldHavePrefix(String prefix) {
        this.prefix().shouldHave(new WebElementCondition[]{Condition.text((String)prefix)});
    }

    @Override
    public void shouldNotHavePrefix() {
        this.prefix().shouldNot(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldBeOpened() {
        this.popUp().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldBeClosed() {
        this.popUp().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void openPopup() {
        if (!this.popUp().is(Condition.exist)) {
            this.element().$(".n2o-input-icon").click();
        }
    }

    @Override
    public void closePopup() {
        if (this.popUp().is(Condition.exist)) {
            this.element().$(".n2o-input-icon").click();
        }
    }

    @Override
    public void shouldBeDisabled() {
        this.element().$(".n2o-input").shouldBe(new WebElementCondition[]{Condition.disabled});
        this.openPopup();
        this.shouldBeClosed();
    }

    protected SelenideElement popUp() {
        return this.element().parent().parent().$(".n2o-pop-up");
    }

    protected SelenideElement prefix() {
        return this.element().$(".time-prefix");
    }

    protected ElementsCollection items(String title) {
        return this.popUp().$$(".n2o-time-picker__header").findBy(Condition.text((String)title)).parent().$$(".dropdown-item");
    }

    protected ElementsCollection hoursItems() {
        return this.items("\u0447\u0430\u0441\u044b");
    }

    protected ElementsCollection minutesItems() {
        return this.items("\u043c\u0438\u043d\u0443\u0442\u044b");
    }

    protected ElementsCollection secondsItems() {
        return this.items("\u0441\u0435\u043a\u0443\u043d\u0434\u044b");
    }

    protected SelenideElement hoursActiveItem() {
        return this.hoursItems().findBy(Condition.cssClass((String)ACTIVE));
    }

    protected SelenideElement minutesActiveItem() {
        return this.minutesItems().findBy(Condition.cssClass((String)ACTIVE));
    }

    protected SelenideElement secondsActiveItem() {
        return this.secondsItems().findBy(Condition.cssClass((String)ACTIVE));
    }
}

