/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.OutputText;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oOutputText
extends N2oControl
implements OutputText {
    @Override
    public void shouldBeEmpty() {
        SelenideElement text = this.text();
        if (text.exists()) {
            text.shouldBe(new WebElementCondition[]{Condition.empty});
        }
    }

    @Override
    public void shouldNotBeEmpty() {
        SelenideElement text = this.text();
        if (text.exists()) {
            text.shouldNotBe(new WebElementCondition[]{Condition.empty});
        }
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        this.should(Condition.text((String)value), duration);
    }

    @Override
    public void shouldHaveIcon(String icon) {
        this.element().$(String.format(".n2o-icon.%s", icon.replace(" ", "."))).shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotHaveValue(String value) {
        this.element().shouldNotHave(new WebElementCondition[]{Condition.text((String)value)});
    }

    @Override
    public String getValue() {
        return this.text().text();
    }

    protected SelenideElement text() {
        return this.element().shouldBe(new WebElementCondition[]{Condition.exist}).$(".text");
    }
}

