/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import net.n2oapp.framework.api.metadata.meta.control.OutputList;
import net.n2oapp.framework.autotest.api.component.control.OutputList;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oOutputList
extends N2oControl
implements OutputList {
    @Override
    public void shouldBeEmpty() {
        this.element().shouldBe(new WebElementCondition[]{Condition.empty});
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shouldHaveValues(String separator, String[] values, Duration ... duration) {
        this.check((ElementsCollection)this.simpleItems().filter(Condition.not((WebElementCondition)Condition.cssClass((String)"n2o-output-list__item--link"))), separator, values, duration);
    }

    @Override
    public void shouldHaveLinkValues(String separator, String[] values, Duration ... duration) {
        this.check(this.linkedItems(), separator, values, duration);
    }

    @Override
    public void shouldHaveDirection(OutputList.DirectionEnum direction) {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)String.format("n2o-output-list--%s", direction.getId()))});
    }

    @Override
    public void shouldHaveLink(String itemValue, String link) {
        this.linkedItems().find(Condition.text((String)itemValue)).shouldHave(new WebElementCondition[]{Condition.attribute((String)"href", (String)link)});
    }

    private void check(ElementsCollection elements, String separator, String[] values, Duration ... duration) {
        elements.shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)values.length)});
        for (int i = 0; i < values.length - 1; ++i) {
            this.should(Condition.text((String)values[i]), elements.get(i), duration);
            this.should(Condition.text((String)separator), elements.get(i).parent().$(".white-space-pre"), duration);
        }
        this.should(Condition.text((String)values[values.length - 1]), elements.last(), duration);
        if (this.element().lastChild().text().equals(elements.last().text())) {
            elements.last().parent().$(".white-space-pre").shouldBe(new WebElementCondition[]{Condition.empty});
        }
    }

    protected ElementsCollection linkedItems() {
        return this.element().$$(".n2o-output-list__item--link");
    }

    protected ElementsCollection simpleItems() {
        return this.element().$$(".n2o-output-list__item");
    }
}

