/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.InputMoneyControl;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oInputMoney
extends N2oControl
implements InputMoneyControl {
    protected static final String INPUT = ".n2o-input-money";

    @Override
    public String getValue() {
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            return input.getValue();
        }
        return this.cellInputElement().text();
    }

    @Override
    public void setValue(String value) {
        this.element().parent().$(INPUT).setValue(value).pressEnter();
    }

    @Override
    public void shouldBeEmpty() {
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            input.shouldHave(new WebElementCondition[]{Condition.empty});
        } else {
            this.cellInputElement().shouldHave(new WebElementCondition[]{Condition.empty});
        }
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        boolean b = value == null || value.isEmpty();
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            this.should(b ? Condition.empty : Condition.exactValue((String)value), input, duration);
        } else {
            this.should(b ? Condition.empty : Condition.exactText((String)value), this.cellInputElement(), duration);
        }
    }

    @Override
    public void shouldHavePlaceholder(String value) {
        WebElementCondition condition = Condition.attribute((String)"placeholder", (String)value);
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            input.shouldHave(new WebElementCondition[]{condition});
        } else {
            this.cellInputElement().shouldHave(new WebElementCondition[]{condition});
        }
    }

    @Override
    public void click() {
        this.inputElement().click();
    }

    @Override
    public void backspace() {
        this.inputElement().sendKeys(new CharSequence[]{Keys.BACK_SPACE});
    }

    protected SelenideElement cellInputElement() {
        return this.element().$(".n2o-editable-cell .n2o-editable-cell-text");
    }

    protected SelenideElement inputElement() {
        return this.element().shouldBe(new WebElementCondition[]{Condition.exist}).parent().$(INPUT);
    }
}

