/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.io.File;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.FileUploadControl;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oFileUploadControl
extends N2oControl
implements FileUploadControl {
    @Override
    public void shouldBeEmpty() {
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
    }

    @Override
    public File uploadFile(File ... file) {
        return this.element().parent().$("input[type='file']").uploadFile(file);
    }

    @Override
    public File uploadFromClasspath(String ... fileName) {
        return this.element().parent().$("input[type='file']").uploadFromClasspath(fileName);
    }

    @Override
    public void deleteFile(int index) {
        this.files().get(index).$(".n2o-file-uploader-remove").hover().shouldBe(new WebElementCondition[]{Condition.visible}).click();
    }

    @Override
    public void shouldHaveUploadFiles(int count) {
        this.files().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)count)});
    }

    @Override
    public void uploadFileShouldHaveName(int index, String fileName, Duration ... duration) {
        SelenideElement element = this.files().get(index).$(".n2o-file-uploader-file-name");
        this.should(Condition.text((String)fileName), element, duration);
    }

    @Override
    public void uploadFileShouldHaveSize(int index, String fileSize) {
        this.files().get(index).$(".n2o-file-uploader-item-size").shouldHave(new WebElementCondition[]{Condition.text((String)fileSize)});
    }

    @Override
    public void uploadFileShouldHaveLink(int index, String href) {
        this.files().get(index).$(".n2o-file-uploader-link").shouldHave(new WebElementCondition[]{Condition.attribute((String)"href", (String)href)});
    }

    @Override
    public void shouldBeDisabled() {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"disabled")});
    }

    protected ElementsCollection files() {
        return this.element().parent().$$(".n2o-file-uploader-files-list .n2o-file-uploader-files-item");
    }
}

