/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.DateInput;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oDateInput
extends N2oControl
implements DateInput {
    private static final String DISABLED = "disabled";

    @Override
    public void shouldBeEmpty() {
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            input.shouldBe(new WebElementCondition[]{Condition.empty});
        } else {
            this.cellInputElement().shouldBe(new WebElementCondition[]{Condition.empty});
        }
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            this.should(Condition.value((String)value), input, duration);
        } else {
            this.should(Condition.text((String)value), this.cellInputElement(), duration);
        }
    }

    @Override
    public String getValue() {
        SelenideElement input = this.inputElement();
        return input.exists() ? input.getValue() : this.cellInputElement().text();
    }

    @Override
    public void setValue(String value) {
        boolean isEditableCell = this.element().is(Condition.cssClass((String)"n2o-editable-cell"));
        if (!this.inputElement().exists() && isEditableCell) {
            this.element().click();
        }
        this.inputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), value});
        if (isEditableCell) {
            this.inputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.ENTER})});
        } else {
            this.inputElement().click();
        }
    }

    @Override
    public void timeButtonShouldHaveLabel(String label) {
        this.element().$(".n2o-calendar-time-container").shouldHave(new WebElementCondition[]{Condition.text((String)label)});
    }

    @Override
    public void timeVal(String hours, String minutes, String seconds) {
        this.element().$(".n2o-calendar-time-container").click();
        this.element().$$(".n2o-pop-up .hour-picker .n2o-calendar-time-unit").find(Condition.text((String)hours)).click();
        this.element().$$(".n2o-pop-up .minute-picker .n2o-calendar-time-unit").find(Condition.text((String)minutes)).click();
        this.element().$$(".n2o-pop-up .second-picker .n2o-calendar-time-unit").find(Condition.text((String)seconds)).click();
        this.element().$$(".n2o-calendar-time-buttons button").find(Condition.text((String)"\u0412\u044b\u0431\u0440\u0430\u0442\u044c")).click();
    }

    @Override
    public void shouldBeDisabled() {
        this.inputElement().shouldBe(new WebElementCondition[]{Condition.disabled});
    }

    @Override
    public void clickCalendarButton() {
        this.element().$(".btn.n2o-calendar-button").click();
    }

    @Override
    public void shouldBeActiveDay(String day) {
        this.calendarDays().findBy(Condition.cssClass((String)"selected")).shouldBe(new WebElementCondition[]{Condition.exist}).shouldHave(new WebElementCondition[]{Condition.text((String)day)});
    }

    @Override
    public void clickDay(String day) {
        ((ElementsCollection)((ElementsCollection)((ElementsCollection)this.calendarDays().filter(Condition.text((String)day))).exclude(Condition.cssClass((String)DISABLED))).exclude(Condition.cssClass((String)"other-month"))).get(0).shouldBe(new WebElementCondition[]{Condition.exist}).click();
    }

    @Override
    public void shouldBeDisableDay(String day) {
        ((ElementsCollection)this.calendarDays().filterBy(Condition.cssClass((String)DISABLED))).find(Condition.text((String)day)).shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotBeDisableDay(String day) {
        ((ElementsCollection)this.calendarDays().filterBy(Condition.cssClass((String)DISABLED))).find(Condition.text((String)day)).shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveCurrentMonth(String month, Duration ... duration) {
        this.should(Condition.text((String)month), this.element().$(".n2o-calendar-header-month-title"), duration);
    }

    @Override
    public void shouldHaveCurrentYear(String year, Duration ... duration) {
        this.should(Condition.text((String)year), this.element().$(".n2o-calendar-header-year-title"), duration);
    }

    @Override
    public void clickPreviousMonthButton() {
        this.element().$(".n2o-calendar-header .fa-angle-left").click();
    }

    @Override
    public void clickNextMonthButton() {
        this.element().$(".n2o-calendar-header .fa-angle-right").click();
    }

    @Override
    public void shouldHavePlaceholder(String value) {
        WebElementCondition condition = Condition.attribute((String)"placeholder", (String)value);
        SelenideElement elm = this.inputElement();
        if (elm.exists()) {
            elm.shouldHave(new WebElementCondition[]{condition});
        } else {
            this.cellInputElement().shouldHave(new WebElementCondition[]{condition});
        }
    }

    @Override
    public void openPopup() {
        this.element().$(".n2o-date-input").should(new WebElementCondition[]{Condition.exist}).click();
    }

    @Override
    public void closePopup() {
        throw new UnsupportedOperationException("Date pop-up cannot be closed without choosing the date");
    }

    @Override
    public void shouldBeOpened() {
        this.popUp().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldBeClosed() {
        this.popUp().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    protected SelenideElement inputElement() {
        this.element().shouldBe(new WebElementCondition[]{Condition.exist});
        return this.element().$(".n2o-date-input input");
    }

    protected SelenideElement cellInputElement() {
        return this.element().$(".n2o-editable-cell .n2o-editable-cell-text");
    }

    protected SelenideElement popUp() {
        return this.element().parent().parent().$(".n2o-pop-up");
    }

    protected ElementsCollection calendarDays() {
        return this.element().$$(".n2o-calendar-day");
    }
}

