/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.application;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.api.metadata.application.SidebarStateEnum;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.collection.Menu;
import net.n2oapp.framework.autotest.api.component.application.Sidebar;
import net.n2oapp.framework.autotest.impl.collection.N2oMenu;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public class N2oSidebar
extends N2oComponent
implements Sidebar {
    public N2oSidebar(SelenideElement element) {
        this.setElement(element);
    }

    @Override
    public void shouldHaveTitle(String title, Duration ... duration) {
        this.should(Condition.exactText((String)title), ((ElementsCollection)this.navBrands().filterBy(Condition.not((WebElementCondition)Condition.cssClass((String)"n2o-brand")))).get(0), duration);
    }

    @Override
    public void shouldHaveBrandLogo(String src) {
        this.element().$(".n2o-brand__image").shouldHave(new WebElementCondition[]{Condition.attributeMatching((String)"src", (String)(".*" + src))});
    }

    @Override
    public void shouldHaveSubtitle(String subtitle, Duration ... duration) {
        this.should(Condition.exactText((String)subtitle), ((ElementsCollection)this.navBrands().filterBy(Condition.not((WebElementCondition)Condition.cssClass((String)"n2o-brand")))).get(1), duration);
    }

    @Override
    public void shouldBeFixed() {
        this.element().parent().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"n2o-layout-fixed")});
    }

    @Override
    public void shouldBeRight() {
        this.element().parent().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"flex-row-reverse")});
    }

    @Override
    public void shouldBeOverlay() {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"n2o-sidebar-overlay")});
    }

    @Override
    public void shouldHaveState(SidebarStateEnum state) {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)state.getId())});
    }

    @Override
    public void clickToggleBtn() {
        this.element().$(".n2o-sidebar__toggler").click();
    }

    @Override
    public Menu nav() {
        return N2oSelenide.collection(this.element().$$(".n2o-sidebar__nav .n2o-sidebar__nav-list>li"), N2oMenu.class);
    }

    @Override
    public Menu extra() {
        return N2oSelenide.collection(this.element().$(".n2o-sidebar__extra").$$("ul > li"), N2oMenu.class);
    }

    protected ElementsCollection navBrands() {
        return this.element().$$(".navbar-brand");
    }
}

