/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.DropDownTree;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public class N2oDropDownTree
extends N2oComponent
implements DropDownTree {
    private static final String CSS_SELECTORS = ".n2o-select-tree-tree-treenode-switcher-open, .n2o-select-tree-tree-treenode-switcher-close";

    @Override
    public DropDownTree.DropDownTreeItem item(int index) {
        return new N2oDropDownTreeItem(this, this.element().$$(CSS_SELECTORS).get(index));
    }

    @Override
    public void shouldHaveItems(int size) {
        this.element().$$(CSS_SELECTORS).shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)size)});
    }

    @Override
    public void clickOnSearchField() {
        this.searchField().click();
    }

    @Override
    public void setValue(String value) {
        this.searchField().sendKeys(new CharSequence[]{value});
    }

    @Override
    public void shouldHaveOption(String label) {
        this.element().$$(CSS_SELECTORS).find(Condition.text((String)label)).shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void clear() {
        this.searchField().clear();
    }

    protected SelenideElement searchField() {
        return this.element().parent().$(".n2o-select-tree-selection-search-input");
    }

    public class N2oDropDownTreeItem
    extends N2oComponent
    implements DropDownTree.DropDownTreeItem {
        private static final String SELECTED_NODE = "n2o-select-tree-tree-treenode-checkbox-checked";
        private static final String SWITCHER = "n2o-select-tree-tree-switcher";

        public N2oDropDownTreeItem(N2oDropDownTree this$0, SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public void expand() {
            if (!this.switcher().has(this.isExpanded())) {
                this.switcher().click();
            }
        }

        @Override
        public void collapse() {
            if (this.switcher().has(this.isExpanded())) {
                this.switcher().click();
            }
        }

        @Override
        public void shouldBeExpanded() {
            this.switcher().shouldHave(new WebElementCondition[]{Condition.cssClass((String)String.format("%s_open", SWITCHER))});
        }

        @Override
        public void shouldBeCollapsed() {
            this.switcher().shouldHave(new WebElementCondition[]{Condition.cssClass((String)String.format("%s_close", SWITCHER))});
        }

        @Override
        public void click() {
            this.element().click();
        }

        @Override
        public void shouldHaveValue(String value, Duration ... duration) {
            this.should(Condition.text((String)value), duration);
        }

        @Override
        public void shouldBeSelected() {
            this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)SELECTED_NODE)});
        }

        @Override
        public void shouldNotBeSelected() {
            this.element().shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)SELECTED_NODE)});
        }

        private WebElementCondition isExpanded() {
            return Condition.cssClass((String)String.format("%s_open", SWITCHER));
        }

        protected SelenideElement switcher() {
            return this.element().$(String.format(".%s", SWITCHER));
        }
    }
}

