/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest;

import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.n2oapp.framework.autotest.api.ComponentLibrary;
import net.n2oapp.framework.autotest.api.collection.ComponentsCollection;
import net.n2oapp.framework.autotest.api.component.Component;

public class ComponentFactory {
    private Set<Class<?>> components = new HashSet();
    private Set<Class<?>> collections = new HashSet();

    public <T extends Component> T produce(SelenideElement element, Class<T> componentClass) {
        Component component = (Component)this.findAndProduce(componentClass, this.components);
        component.setElement(element);
        return (T)component;
    }

    public <T extends ComponentsCollection> T produce(ElementsCollection elements, Class<T> collectionClass) {
        ComponentsCollection collection = (ComponentsCollection)this.findAndProduce(collectionClass, this.collections);
        collection.setElements(elements);
        return (T)collection;
    }

    @SafeVarargs
    public final ComponentFactory addComponents(Class<? extends Component> ... components) {
        this.components.addAll(Arrays.asList(components));
        return this;
    }

    @SafeVarargs
    public final ComponentFactory addCollections(Class<? extends ComponentsCollection> ... collections) {
        this.collections.addAll(Arrays.asList(collections));
        return this;
    }

    public ComponentFactory addLibrary(ComponentLibrary library) {
        this.components.addAll(library.components());
        this.collections.addAll(library.collections());
        return this;
    }

    private Object findAndProduce(Class<?> targetClass, Set<Class<?>> candidates) {
        Optional<Class<?>> found = this.find(targetClass, candidates);
        if (!found.isPresent()) {
            throw new IllegalArgumentException("Implementation not found for " + String.valueOf(targetClass));
        }
        try {
            return found.get().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Optional<Class<?>> find(Class<?> targetClass, Set<Class<?>> candidates) {
        if (targetClass.isInterface()) {
            for (Class<?> candidate : candidates) {
                if (!targetClass.isAssignableFrom(candidate)) continue;
                return Optional.of(candidate);
            }
        } else {
            return Optional.of(targetClass);
        }
        return Optional.empty();
    }
}

