package net.n2oapp.framework.autotest.impl.component.snippet;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.api.component.snippet.Html;

import java.time.Duration;
import java.util.Map;

public class N2oHtml extends N2oSnippet implements Html {

    @Override
    public void shouldHaveElement(String cssSelector) {
        element().$(cssSelector).shouldBe(Condition.exist);
    }

    @Override
    public void shouldHaveText(String text, Duration... duration) {
        should(Condition.text(text), duration);
    }

    @Override
    public void shouldHaveElementWithAttributes(String cssSelector, Map<String, String> attributes) {
        SelenideElement element = element().$(cssSelector).shouldBe(Condition.exist);
        attributes.entrySet().forEach(
                e -> element.shouldHave(Condition.attribute(e.getKey(), e.getValue()))
        );
    }
}
