/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.run;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.config.AppConfig;
import net.n2oapp.framework.api.config.ConfigBuilder;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.QueryProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.application.N2oApplication;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.meta.page.Page;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileBindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.api.rest.ControllerFactory;
import net.n2oapp.framework.api.rest.ExportResponse;
import net.n2oapp.framework.api.rest.GetDataResponse;
import net.n2oapp.framework.api.rest.N2oResponse;
import net.n2oapp.framework.api.rest.SetDataResponse;
import net.n2oapp.framework.api.rest.ValidationDataResponse;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.ui.AlertMessagesConstructor;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.N2oConfigBuilder;
import net.n2oapp.framework.config.metadata.compile.context.ApplicationContext;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.N2oSubModelsProcessor;
import net.n2oapp.framework.engine.data.N2oOperationProcessor;
import net.n2oapp.framework.engine.modules.stack.DataProcessingStack;
import net.n2oapp.framework.ui.controller.DataController;
import net.n2oapp.framework.ui.controller.N2oControllerFactory;
import net.n2oapp.framework.ui.controller.action.OperationController;
import net.n2oapp.framework.ui.controller.action.ValidationController;
import net.n2oapp.framework.ui.controller.export.ExportController;
import net.n2oapp.framework.ui.controller.export.format.CsvFileGenerator;
import net.n2oapp.framework.ui.controller.export.format.FileGeneratorFactory;
import net.n2oapp.framework.ui.controller.query.MergeValuesController;
import net.n2oapp.framework.ui.controller.query.QueryController;
import net.n2oapp.framework.ui.controller.query.SimpleDefaultValuesController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class N2oController {
    private N2oApplicationBuilder builder;
    private final DataProcessingStack dataProcessingStack;
    private final AlertMessageBuilder messageBuilder;
    private final AlertMessagesConstructor messagesConstructor;
    private final QueryProcessor queryProcessor;
    private final N2oOperationProcessor operationProcessor;
    private ConfigBuilder<AppConfig> configBuilder;
    private final DomainProcessor domainProcessor;
    private final InvocationProcessor serviceProvider;
    private static final String DEFAULT_APP_ID = "default";
    @Value(value="${n2o.config.path}")
    private String basePath;
    @Value(value="${n2o.application.id}")
    private String defaultApplicationId;

    @Autowired
    public N2oController(DataProcessingStack dataProcessingStack, AlertMessageBuilder messageBuilder, QueryProcessor queryProcessor, N2oOperationProcessor operationProcessor, DomainProcessor domainProcessor, AlertMessagesConstructor messagesConstructor, InvocationProcessor serviceProvider) {
        this.queryProcessor = queryProcessor;
        this.dataProcessingStack = dataProcessingStack;
        this.messageBuilder = messageBuilder;
        this.operationProcessor = operationProcessor;
        this.domainProcessor = domainProcessor;
        this.messagesConstructor = messagesConstructor;
        this.serviceProvider = serviceProvider;
    }

    @GetMapping(value={"/n2o/config"})
    public AppConfig config() {
        List apps = this.builder.getEnvironment().getMetadataRegister().find(N2oApplication.class);
        Assert.isTrue((!apps.isEmpty() ? 1 : 0) != 0, (String)"Not found application.xml file");
        String applicationId = this.builder.getEnvironment().getSystemProperties().getProperty("n2o.application.id");
        if (applicationId.equals(DEFAULT_APP_ID)) {
            Optional<SourceInfo> applicationInfo = this.builder.getEnvironment().getMetadataRegister().find(N2oApplication.class).stream().filter(a -> !a.getId().equals(DEFAULT_APP_ID)).findFirst();
            applicationId = applicationInfo.isPresent() ? applicationInfo.get().getId() : DEFAULT_APP_ID;
        }
        this.configBuilder.menu((Object)((ReadCompileBindTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)this.builder.read().transform()).validate()).compile()).transform()).bind()).get((CompileContext)new ApplicationContext(applicationId), new DataSet()));
        return this.configBuilder.get();
    }

    @GetMapping(value={"/n2o/page/**", "/n2o/page/", "/n2o/page"})
    public Page page(HttpServletRequest request) {
        String path = this.getPath(request, "/n2o/page");
        CompileContext context = this.builder.route(path, Page.class, request.getParameterMap());
        N2oSubModelsProcessor n2oSubModelsProcessor = new N2oSubModelsProcessor(this.queryProcessor, this.domainProcessor);
        n2oSubModelsProcessor.setEnvironment(this.builder.getEnvironment());
        return (Page)((ReadCompileBindTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)this.builder.read().transform()).validate()).compile()).transform()).bind()).get(context, context.getParams(path, request.getParameterMap()), (SubModelsProcessor)n2oSubModelsProcessor);
    }

    @GetMapping(value={"/n2o/data/**", "/n2o/data/", "/n2o/data"})
    public ResponseEntity<GetDataResponse> getData(HttpServletRequest request) {
        String path = this.getPath(request, "/n2o/data");
        DataController dataController = new DataController(this.createControllerFactory(this.builder.getEnvironment()), this.builder.getEnvironment());
        dataController.setMessageBuilder(this.messageBuilder);
        GetDataResponse response = dataController.getData(path, request.getParameterMap(), null);
        return ResponseEntity.status((int)response.getStatus()).body((Object)response);
    }

    @PostMapping(value={"/n2o/data/**", "/n2o/data/", "/n2o/data"})
    public ResponseEntity<SetDataResponse> setData(@RequestBody Object body, HttpServletRequest request) {
        String path = this.getPath(request, "/n2o/data");
        DataController dataController = new DataController(this.createControllerFactory(this.builder.getEnvironment()), this.builder.getEnvironment());
        dataController.setMessageBuilder(this.messageBuilder);
        SetDataResponse dataResponse = dataController.setData(path, request.getParameterMap(), this.getHeaders(request), (Object)this.getBody(body), null);
        return ResponseEntity.status((int)dataResponse.getStatus()).body((Object)dataResponse);
    }

    @PostMapping(path={"/n2o/validation/**", "/n2o/validation/", "/n2o/validation"})
    public ResponseEntity<ValidationDataResponse> validateData(@RequestBody Object body, HttpServletRequest request) {
        String path = this.getPath(request, "/n2o/validation");
        DataController dataController = new DataController(this.createControllerFactory(this.builder.getEnvironment()), this.builder.getEnvironment());
        dataController.setMessageBuilder(this.messageBuilder);
        ValidationDataResponse dataResponse = dataController.validateData(path, (Object)this.getBody(body));
        return ResponseEntity.status((int)dataResponse.getStatus()).body((Object)dataResponse);
    }

    @GetMapping(value={"/n2o/export/**", "/n2o/export/", "/n2o/export"})
    public ResponseEntity<byte[]> export(HttpServletRequest request) {
        FileGeneratorFactory fileGeneratorFactory = new FileGeneratorFactory(List.of(new CsvFileGenerator()));
        DataController dataController = new DataController(this.createControllerFactory(this.builder.getEnvironment()), this.builder.getEnvironment());
        ExportController exportController = new ExportController(this.builder.getEnvironment(), dataController, fileGeneratorFactory);
        String url = request.getParameter("url");
        String format = request.getParameter("format");
        String charset = request.getParameter("charset");
        String dataPrefix = "/n2o/data";
        String path = RouteUtil.parsePath((String)url.substring(url.indexOf(dataPrefix) + dataPrefix.length()));
        Map params = RouteUtil.parseQueryParams((String)RouteUtil.parseQuery((String)url));
        if (params == null) {
            throw new N2oException("Query-\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u0443\u0441\u0442\u043e\u0439");
        }
        GetDataResponse dataResponse = exportController.getData(path, params, null);
        Map headers = exportController.getHeaders(path, params);
        ExportResponse exportResponse = exportController.export(dataResponse.getList(), format, charset, headers);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((int)exportResponse.getStatus()).contentLength((long)exportResponse.getContentLength()).header("Content-Type", new String[]{exportResponse.getContentType()})).header("Content-Disposition", new String[]{exportResponse.getContentDisposition()})).header("Content-Encoding", new String[]{exportResponse.getCharacterEncoding()})).body((Object)exportResponse.getFile());
    }

    @ExceptionHandler(value={N2oException.class})
    public ResponseEntity<N2oResponse> sendErrorMessage(N2oException e) {
        return ResponseEntity.status((int)e.getHttpStatus()).body((Object)new N2oResponse());
    }

    private DataSet getBody(Object body) {
        if (body instanceof Map) {
            return new DataSet((Map)body);
        }
        DataSet dataSet = new DataSet("$list", body);
        dataSet.put("$count", (Object)(body != null ? ((List)body).size() : 0));
        return dataSet;
    }

    public void setUp(N2oApplicationBuilder builder) {
        this.builder = builder;
        this.configBuilder = new N2oConfigBuilder(new AppConfig(), new ObjectMapper(), builder.getEnvironment().getSystemProperties(), builder.getEnvironment().getContextProcessor());
    }

    public void addConfigProperty(String key, Object value) {
        this.configBuilder.add(key, value);
    }

    private ControllerFactory createControllerFactory(MetadataEnvironment environment) {
        N2oSubModelsProcessor subModelsProcessor = new N2oSubModelsProcessor(this.queryProcessor, this.domainProcessor);
        subModelsProcessor.setEnvironment(environment);
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("queryController", new QueryController(this.dataProcessingStack, this.queryProcessor, (SubModelsProcessor)subModelsProcessor, this.messageBuilder, this.messagesConstructor));
        beans.put("operationController", new OperationController(this.dataProcessingStack, this.operationProcessor, this.messageBuilder, environment, this.messagesConstructor));
        beans.put("validationController", new ValidationController(this.serviceProvider, this.domainProcessor));
        beans.put("mergeValuesController", new MergeValuesController(this.dataProcessingStack, this.queryProcessor, (SubModelsProcessor)subModelsProcessor, this.messageBuilder));
        beans.put("simpleDefaultValuesController", new SimpleDefaultValuesController(this.dataProcessingStack, this.queryProcessor, (SubModelsProcessor)subModelsProcessor, this.messageBuilder));
        return new N2oControllerFactory(beans);
    }

    private String getPath(HttpServletRequest request, String prefix) {
        String path = request.getRequestURI().substring(request.getRequestURI().indexOf(prefix) + prefix.length());
        return RouteUtil.normalize((String)(!path.isEmpty() ? path : "/"));
    }

    private Map<String, String[]> getHeaders(HttpServletRequest req) {
        HashMap<String, String[]> headers = new HashMap<String, String[]>();
        Enumeration iter = req.getHeaderNames();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            headers.put(name, new String[]{req.getHeader(name)});
        }
        return headers;
    }
}

