/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.widget.table;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.SortingDirection;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.collection.Cells;
import net.n2oapp.framework.autotest.api.collection.FieldSets;
import net.n2oapp.framework.autotest.api.collection.Fields;
import net.n2oapp.framework.autotest.api.collection.TableHeaders;
import net.n2oapp.framework.autotest.api.collection.Toolbar;
import net.n2oapp.framework.autotest.api.component.widget.Paging;
import net.n2oapp.framework.autotest.api.component.widget.table.TableWidget;
import net.n2oapp.framework.autotest.impl.component.widget.N2oPaging;
import net.n2oapp.framework.autotest.impl.component.widget.N2oStandardWidget;

public class N2oTableWidget
extends N2oStandardWidget
implements TableWidget {
    @Override
    public TableWidget.Columns columns() {
        return new N2oColumns();
    }

    @Override
    public TableWidget.Filters filters() {
        return new N2oFilters();
    }

    @Override
    public Paging paging() {
        return new N2oPaging(this.element());
    }

    public class N2oColumns
    implements TableWidget.Columns {
        @Override
        public TableHeaders headers() {
            return N2oSelenide.collection(N2oTableWidget.this.element().$$(".n2o-advanced-table .header tr th"), TableHeaders.class);
        }

        @Override
        public TableWidget.Rows rows() {
            return new N2oRows();
        }
    }

    public class N2oFilters
    implements TableWidget.Filters {
        @Override
        public Toolbar toolbar() {
            return N2oSelenide.collection(N2oTableWidget.this.element().$$(".n2o-filter .btn"), Toolbar.class);
        }

        @Override
        public Fields fields() {
            return N2oSelenide.collection(N2oTableWidget.this.element().$$(".n2o-filter .n2o-fieldset .n2o-form-group"), Fields.class);
        }

        @Override
        public FieldSets fieldsets() {
            return N2oSelenide.collection(N2oTableWidget.this.element().$$(".n2o-fieldset"), FieldSets.class);
        }

        @Override
        public void shouldBeVisible() {
            this.filter().shouldBe(new WebElementCondition[]{Condition.visible});
        }

        @Override
        public void shouldBeHidden() {
            this.filter().shouldBe(new WebElementCondition[]{Condition.hidden});
        }

        protected SelenideElement filter() {
            return N2oTableWidget.this.element().$(".n2o-filter");
        }
    }

    public class N2oRows
    implements TableWidget.Rows {
        @Override
        public Cells row(int index) {
            return N2oSelenide.collection(this.rows().get(index).$$("td"), Cells.class);
        }

        @Override
        public void shouldHaveSize(int size, Duration ... duration) {
            N2oTableWidget.this.should(CollectionCondition.size((int)size), this.rows(), duration);
        }

        @Override
        public void shouldNotHaveRows() {
            this.rows().shouldBe(new WebElementsCondition[]{CollectionCondition.empty});
        }

        @Override
        public void shouldBeSelected(int row) {
            this.rows().get(row).shouldBe(new WebElementCondition[]{Condition.attribute((String)"data-focused", (String)"true")});
        }

        @Override
        public void shouldNotHaveSelectedRows() {
            ((ElementsCollection)this.rows().filterBy(Condition.cssClass((String)"table-active"))).shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)0)});
        }

        @Override
        public void columnShouldHaveTexts(int index, List<String> texts, Duration ... duration) {
            N2oTableWidget.this.should(CollectionCondition.texts(texts), this.column(index), duration);
        }

        @Override
        public void columnShouldBeEmpty(int index) {
            this.column(index).shouldHave(new WebElementsCondition[]{CollectionCondition.empty});
        }

        @Override
        public List<String> columnTexts(int index) {
            return this.column(index).texts();
        }

        @Override
        public void columnShouldBeSortedBy(int columnIndex, SortingDirection direction) {
            ElementsCollection elements = N2oTableWidget.this.element().should(new WebElementCondition[]{Condition.exist}).$$(".table-row td:nth-child(" + ++columnIndex + ")");
            switch (direction) {
                case ASC: {
                    elements.should(new WebElementsCondition[]{CollectionCondition.exactTexts(elements.texts().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList()))});
                    break;
                }
                case DESC: {
                    elements.should(new WebElementsCondition[]{CollectionCondition.exactTexts(elements.texts().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList()))});
                }
            }
        }

        protected ElementsCollection column(int index) {
            return N2oTableWidget.this.element().$$(String.format(".table-row[data-deep-level] td:nth-child(%d)", ++index));
        }

        protected ElementsCollection rows() {
            return N2oTableWidget.this.element().$$(".n2o-advanced-table tbody .table-row:not(.table-row-presentation)");
        }
    }
}

