/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.widget;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import net.n2oapp.framework.autotest.BadgePosition;
import net.n2oapp.framework.autotest.api.component.widget.TreeWidget;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;
import net.n2oapp.framework.autotest.impl.component.widget.N2oStandardWidget;

public class N2oTreeWidget
extends N2oStandardWidget
implements TreeWidget {
    protected String treeItem = ".n2o-rc-tree-treenode-switcher-open, .n2o-rc-tree-treenode-switcher-close";

    @Override
    public N2oTreeItem item(int index) {
        return new N2oTreeItem(this.element().$$(this.treeItem).get(index));
    }

    @Override
    public void shouldHaveItem(String label) {
        this.element().$$(this.treeItem).find(Condition.text((String)label)).shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveItems(int size) {
        this.element().$$(this.treeItem).shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)size)});
    }

    public class N2oTreeItem
    extends N2oComponent
    implements TreeWidget.TreeItem {
        private static final String SWITCHER = "n2o-rc-tree-switcher";

        public N2oTreeItem(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public void expand() {
            if (!this.switcher().has(this.isExpanded())) {
                this.switcher().click();
            }
        }

        @Override
        public void collapse() {
            if (!this.switcher().has(this.isExpanded())) {
                this.switcher().click();
            }
        }

        @Override
        public void shouldBeExpanded() {
            this.switcher().shouldHave(new WebElementCondition[]{Condition.cssClass((String)String.format("%s_open", SWITCHER))});
        }

        @Override
        public void shouldBeCollapsed() {
            this.switcher().shouldHave(new WebElementCondition[]{Condition.cssClass((String)String.format("%s_close", SWITCHER))});
        }

        @Override
        public void badgeShouldHavePosition(BadgePosition position) {
            if (position.equals((Object)BadgePosition.LEFT)) {
                this.element().$(".n2o-rc-tree-label").shouldHave(new WebElementCondition[]{Condition.cssValue((String)"order", (String)"1")});
            } else {
                this.element().$(".n2o-rc-tree-label").shouldHave(new WebElementCondition[]{Condition.cssValue((String)"order", (String)"0")});
            }
        }

        private WebElementCondition isExpanded() {
            return Condition.cssClass((String)String.format("%s_open", SWITCHER));
        }

        protected SelenideElement switcher() {
            return this.element().parent().$(String.format(".%s", SWITCHER));
        }
    }
}

