/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.widget;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.widget.Paging;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public class N2oPaging
extends N2oComponent
implements Paging {
    protected String ellipsisLocator = ".ellipsis";
    protected String pageItemLocator = ".page-item";
    protected String countButtonLocator = ".pagination__total__button";
    protected String pagesLocator = ".pagination-pages";
    protected String nextButtonLocator = ".next";
    protected String prevButtonLocator = ".prev";
    protected String paginationContainer = ".pagination-container";
    protected String totalTextLocator = ".pagination__total__text";

    public N2oPaging(SelenideElement element) {
        this.setElement(element);
    }

    @Override
    public void shouldHaveActivePage(String label, Duration ... duration) {
        SelenideElement e = this.element().$(this.paginationContainer.concat(" ").concat(this.pageItemLocator).concat(".active.page-link .title"));
        this.should(Condition.text((String)label), e, duration);
    }

    @Override
    public void selectPage(String number) {
        this.pageNumberButton(number).click();
    }

    @Override
    public void shouldHavePageNumber(String number) {
        this.pageNumberButton(number).shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public int totalElements() {
        String info = this.paginationInfo().text();
        info = info.split(" ")[2];
        return Integer.parseInt(info);
    }

    @Override
    public void shouldHaveTotalElements(int count) {
        this.paginationInfo().scrollTo().should(new WebElementCondition[]{Condition.matchText((String)String.valueOf(count))});
    }

    @Override
    public void shouldNotHaveTotalElements() {
        this.paginationInfo().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHavePrev() {
        this.prevButton().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotHavePrev() {
        this.prevButton().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void prevButtonShouldBeEnabled() {
        this.prevButton().shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)"disabled")});
    }

    @Override
    public void prevButtonShouldBeDisabled() {
        this.prevButton().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"disabled")});
    }

    @Override
    public void prevShouldHaveLabel(String label, Duration ... duration) {
        this.should(Condition.text((String)label), this.prevButton().parent(), duration);
    }

    @Override
    public void prevShouldHaveIcon(String icon) {
        this.prevButton().$("i").shouldHave(new WebElementCondition[]{Condition.attribute((String)"class", (String)icon)});
    }

    @Override
    public void selectPrev() {
        this.prevButton().click();
    }

    @Override
    public void shouldNotHaveNext() {
        this.nextButton().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveNext() {
        this.nextButton().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void nextShouldHaveLabel(String label, Duration ... duration) {
        this.should(Condition.text((String)label), this.nextButton().parent(), duration);
    }

    @Override
    public void nextShouldHaveIcon(String icon) {
        this.nextButton().$("i").shouldHave(new WebElementCondition[]{Condition.attribute((String)"class", (String)icon)});
    }

    @Override
    public void selectNext() {
        this.nextButton().click();
    }

    @Override
    public void nextButtonShouldBeEnabled() {
        this.nextButton().shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)"disabled")});
    }

    @Override
    public void nextButtonShouldBeDisabled() {
        this.nextButton().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"disabled")});
    }

    @Override
    public void shouldHaveFirst() {
        this.firstPage().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void selectFirst() {
        if (this.firstPage().$(this.pageItemLocator).exists()) {
            this.firstPage().$(this.pageItemLocator).click();
        } else {
            this.firstPage().click();
        }
    }

    @Override
    public void shouldNotHaveLast() {
        this.lastPage().$(".title").shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveLast() {
        this.lastPage().$(".title").shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void lastShouldHavePage(String label, Duration ... duration) {
        this.should(Condition.text((String)label), this.lastPage().parent(), duration);
    }

    @Override
    public void selectLast() {
        if (this.lastPage().$(this.pageItemLocator).is(Condition.exist)) {
            this.lastPage().$(this.pageItemLocator).click();
        } else {
            this.lastPage().click();
        }
    }

    @Override
    public void firstPageShouldHaveEllipsis() {
        this.firstPage().$(this.ellipsisLocator).shouldBe(new WebElementCondition[]{Condition.visible});
    }

    @Override
    public void firstPageShouldNotHaveEllipsis() {
        this.firstPage().$(this.ellipsisLocator).shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void lastPageShouldHaveEllipsis() {
        this.lastPage().$(this.ellipsisLocator).shouldBe(new WebElementCondition[]{Condition.visible});
    }

    @Override
    public void lastPageShouldNotHaveEllipsis() {
        this.lastPage().$(this.ellipsisLocator).shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void pageNumberButtonShouldBeVisible(String number) {
        this.pageNumberButton(number).shouldBe(new WebElementCondition[]{Condition.visible});
    }

    @Override
    public void pageNumberButtonShouldNotBeVisible(String number) {
        this.pageNumberButton(number).shouldNotBe(new WebElementCondition[]{Condition.visible});
    }

    @Override
    public void countButtonShouldBeVisible() {
        this.countButton().shouldBe(new WebElementCondition[]{Condition.visible});
    }

    @Override
    public void countButtonShouldNotBeVisible() {
        this.countButton().shouldNot(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void countButtonClick() {
        this.countButton().click();
    }

    @Override
    public void shouldExists() {
        this.element().$(this.paginationContainer).lastChild().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotExists() {
        if (this.element().$(this.paginationContainer).exists()) {
            this.element().$(this.paginationContainer).lastChild().shouldNotHave(new WebElementCondition[]{Condition.exist});
        } else {
            this.element().$(this.paginationContainer).shouldNotBe(new WebElementCondition[]{Condition.exist});
        }
    }

    protected SelenideElement pageNumberButton(String number) {
        return this.element().$$(this.paginationContainer.concat(" ").concat(this.pageItemLocator)).findBy(Condition.text((String)number));
    }

    protected SelenideElement paginationInfo() {
        return this.element().$(this.paginationContainer.concat(" ").concat(this.totalTextLocator));
    }

    protected SelenideElement prevButton() {
        return this.element().$(this.paginationContainer.concat(" ").concat(this.prevButtonLocator));
    }

    protected SelenideElement nextButton() {
        return this.element().$(this.paginationContainer.concat(" ").concat(this.nextButtonLocator));
    }

    protected SelenideElement firstPage() {
        return this.element().$$(this.pagesLocator.concat(" > .page-item, .extra-page-item")).first();
    }

    protected SelenideElement lastPage() {
        return this.element().$$(this.pagesLocator.concat(" > .page-item, .extra-page-item")).last();
    }

    protected SelenideElement countButton() {
        return this.element().$(this.countButtonLocator);
    }
}

