/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.snippet;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ShapeType;
import net.n2oapp.framework.api.metadata.meta.control.TextPosition;
import net.n2oapp.framework.autotest.api.component.snippet.Image;
import net.n2oapp.framework.autotest.impl.component.snippet.N2oSnippet;

public class N2oImage
extends N2oSnippet
implements Image {
    @Override
    public void shouldHaveTitle(String text, Duration ... duration) {
        this.should(Condition.text((String)text), this.imageInfo().$(".n2o-image__info_label"), duration);
    }

    @Override
    public void shouldHaveDescription(String text, Duration ... duration) {
        this.should(Condition.text((String)text), this.imageInfo().$(".n2o-image__info_description"), duration);
    }

    @Override
    public void shouldHaveShape(ShapeType shape) {
        this.element().$(".n2o-image__image-container").should(new WebElementCondition[]{Condition.cssClass((String)shape.getId())});
    }

    @Override
    public void shouldHaveUrl(String url) {
        this.image().should(new WebElementCondition[]{Condition.attribute((String)"src", (String)url)});
    }

    @Override
    public void shouldHaveWidth(int width) {
        this.image().should(new WebElementCondition[]{Condition.attributeMatching((String)"style", (String)String.format(".*width: %dpx;.*", width))});
    }

    @Override
    public void shouldHaveTextPosition(TextPosition position) {
        this.element().$(".n2o-image__content").should(new WebElementCondition[]{Condition.cssClass((String)position.name())});
    }

    @Override
    public void shouldHaveText(String text, Duration ... duration) {
        this.should(Condition.text((String)text), duration);
    }

    protected SelenideElement imageInfo() {
        return this.element().parent().parent().$(".n2o-image__info");
    }

    protected SelenideElement image() {
        return this.element().$(".n2o-image__image");
    }
}

