/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.snippet;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.Colors;
import net.n2oapp.framework.autotest.api.component.snippet.Alert;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;
import net.n2oapp.framework.autotest.impl.component.snippet.N2oSnippet;

public class N2oAlert
extends N2oSnippet
implements Alert {
    public N2oAlert() {
    }

    public N2oAlert(SelenideElement element) {
        this.setElement(element);
    }

    @Override
    public void shouldHaveColor(Colors color) {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)String.format("alert-%s", color.name().toLowerCase()))});
    }

    @Override
    public void shouldHaveTitle(String text, Duration ... duration) {
        this.should(Condition.text((String)text), this.element().$(".n2o-alert-segment__title"), duration);
    }

    @Override
    public void shouldHaveUrl(String url) {
        this.element().$("a").shouldHave(new WebElementCondition[]{Condition.attribute((String)"href", (String)url)});
    }

    @Override
    public void shouldHaveStacktrace() {
        this.element().should(new WebElementCondition[]{Condition.cssClass((String)"with-details")});
    }

    @Override
    public void shouldHaveText(String text, Duration ... duration) {
        this.should(Condition.text((String)text), this.element().$(".n2o-alert-segment__text"), duration);
    }

    @Override
    public void shouldHaveTimestamp(String timestamp, Duration ... duration) {
        this.should(Condition.text((String)timestamp), this.element().$(".n2o-alert-segment__timestamp"), duration);
    }

    @Override
    public void shouldNotExists(Duration ... duration) {
        this.should(Condition.not((WebElementCondition)Condition.exist), this.element(), duration);
    }

    @Override
    public Alert.CloseButton closeButton() {
        return new N2oCloseButton(this.element().$(".n2o-alert-segment__icon-close"));
    }

    @Override
    public void click() {
        this.element().click();
    }

    public static class N2oCloseButton
    extends N2oComponent
    implements Alert.CloseButton {
        public N2oCloseButton(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public void click() {
            this.element().click();
        }
    }
}

