/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.region;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.region.RegionItems;
import net.n2oapp.framework.autotest.api.component.region.TabsRegion;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;
import net.n2oapp.framework.autotest.impl.component.region.N2oRegion;
import org.openqa.selenium.WebElement;

public class N2oTabsRegion
extends N2oRegion
implements TabsRegion {
    private static final String SCROLL_BAR = "scrollable";

    @Override
    public TabsRegion.TabItem tab(int index) {
        return new N2oTabItem(((ElementsCollection)this.navItem().shouldBe(new WebElementsCondition[]{CollectionCondition.sizeGreaterThan((int)index)})).get(index));
    }

    @Override
    public void shouldHaveSize(int size) {
        this.navItem().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)size)});
    }

    @Override
    public void shouldHaveMaxHeight(int height) {
        this.getTabsContent().shouldBe(new WebElementCondition[]{Condition.attributeMatching((String)"style", (String)String.format(".*max-height: %dpx;.*", height))});
    }

    @Override
    public void shouldHaveScrollbar() {
        this.getTabsContent().shouldHave(new WebElementCondition[]{Condition.cssClass((String)SCROLL_BAR)});
    }

    @Override
    public void shouldNotHaveScrollbar() {
        this.getTabsContent().shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)SCROLL_BAR)});
    }

    @Override
    public TabsRegion.TabItem tab(WebElementCondition by) {
        return new N2oTabItem(this.navItem().findBy(by));
    }

    protected SelenideElement getTabsContent() {
        return this.element().$(".tabs__content");
    }

    protected ElementsCollection navItem() {
        return this.element().$$(".tabs-nav-item");
    }

    public static class N2oTabItem
    extends N2oComponent
    implements TabsRegion.TabItem {
        public N2oTabItem(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public RegionItems content() {
            return this.content("nested-content");
        }

        @Override
        public RegionItems content(String className) {
            SelenideElement elm = this.element().parent().parent().parent().$$(".tabs__content--single").findBy(Condition.cssClass((String)"active"));
            final ElementsCollection nestingElements = elm.$$(".tabs__content--single.active .tabs__content--single.active > div > ." + className);
            ElementsCollection firstLevelElements = (ElementsCollection)elm.$$(".tabs__content--single.active > div > ." + className).filter(new WebElementCondition("shouldBeFirstLevelElement"){

                @Nonnull
                public CheckResult check(Driver driver, WebElement element) {
                    boolean result = StreamSupport.stream(nestingElements.spliterator(), false).noneMatch(element::equals);
                    return new CheckResult(result ? CheckResult.Verdict.ACCEPT : CheckResult.Verdict.REJECT, null);
                }
            });
            return N2oSelenide.collection(firstLevelElements, RegionItems.class);
        }

        @Override
        public void click() {
            this.element().click();
        }

        @Override
        public void shouldHaveName(String text, Duration ... duration) {
            this.should(Condition.text((String)text), duration);
        }

        @Override
        public void shouldNotHaveTitle() {
            this.element().shouldHave(new WebElementCondition[]{Condition.exactText((String)"")});
        }

        @Override
        public void shouldBeActive() {
            this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"active")});
        }

        @Override
        public void shouldNotBeActive() {
            this.element().shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)"active")});
        }

        @Override
        public void shouldBeInvalid() {
            this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"invalid")});
        }

        @Override
        public void shouldBeValid() {
            this.element().shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)"invalid")});
        }

        @Override
        public void scrollUp() {
            Selenide.executeJavaScript((String)"document.querySelector('.tabs__content').scrollTop = 0", (Object[])new Object[0]);
        }

        @Override
        public void scrollDown() {
            Selenide.executeJavaScript((String)"document.querySelector('.tabs__content').scrollTop = document.querySelector('.tabs__content').scrollHeight", (Object[])new Object[0]);
        }

        @Override
        public void shouldBeEnabled() {
            this.element().shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)"disabled")});
        }

        @Override
        public void shouldBeDisabled() {
            this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"disabled")});
        }
    }
}

