/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.page;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import javax.annotation.Nonnull;
import net.n2oapp.framework.api.metadata.application.NavigationLayout;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.collection.Alerts;
import net.n2oapp.framework.autotest.api.collection.Toolbar;
import net.n2oapp.framework.autotest.api.component.application.Footer;
import net.n2oapp.framework.autotest.api.component.application.Sidebar;
import net.n2oapp.framework.autotest.api.component.button.StandardButton;
import net.n2oapp.framework.autotest.api.component.header.SimpleHeader;
import net.n2oapp.framework.autotest.api.component.page.Page;
import net.n2oapp.framework.autotest.api.component.snippet.Alert;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;
import net.n2oapp.framework.autotest.impl.component.application.N2oFooter;
import net.n2oapp.framework.autotest.impl.component.application.N2oSidebar;
import net.n2oapp.framework.autotest.impl.component.header.N2oSimpleHeader;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class N2oPage
extends N2oComponent
implements Page {
    @Override
    public SimpleHeader header() {
        return new N2oSimpleHeader(this.element().$(".n2o-header"));
    }

    @Override
    public Sidebar sidebar() {
        return new N2oSidebar(this.element().$(".n2o-sidebar"));
    }

    @Override
    public Footer footer() {
        return new N2oFooter(this.element().$(".n2o-footer"));
    }

    @Override
    public Page.PageToolbar toolbar() {
        return new N2oPageToolbar();
    }

    @Override
    public Page.Breadcrumb breadcrumb() {
        return new N2oBreadcrumb(this.element().$(".breadcrumb"));
    }

    @Override
    public Page.Overlay overlay() {
        return new N2oOverlay(this.element().$(".table-row-overlay"));
    }

    @Override
    public Page.Dialog dialog(String title) {
        return new N2oDialog(this.element().$$(".modal-dialog").findBy(Condition.text((String)title)).parent());
    }

    @Override
    public Page.Popover popover(String title) {
        return new N2oPopover(this.element().$$(".popover .popover-header, .popover-body").findBy(Condition.text((String)title)).parent());
    }

    @Override
    public Alerts alerts(Alert.Placement placement) {
        return N2oSelenide.collection(this.element().$$(String.format(".n2o-alerts-container .%s .n2o-alert", placement.name())), Alerts.class);
    }

    @Override
    public void shouldHaveUrlMatches(String regex) {
        this.element().should(new WebElementCondition[]{new UrlMatch(regex)});
    }

    @Override
    public void shouldHaveTitle(String title, Duration ... duration) {
        this.should(Condition.text((String)title), this.element().$(".n2o-page__title"), duration);
    }

    @Override
    public void scrollUp() {
        this.element().click();
        this.element().sendKeys(new CharSequence[]{Keys.HOME});
    }

    @Override
    public void scrollDown() {
        this.element().click();
        this.element().sendKeys(new CharSequence[]{Keys.END});
    }

    @Override
    public void shouldHaveCssClass(String classname) {
        this.body().shouldHave(new WebElementCondition[]{Condition.cssClass((String)classname)});
    }

    @Override
    public void shouldHaveStyle(String style) {
        this.body().shouldHave(new WebElementCondition[]{Condition.attribute((String)"style", (String)style)});
    }

    @Override
    public void shouldHaveLayout(NavigationLayout layout) {
        switch (layout) {
            case fullSizeHeader: {
                this.element().$(".n2o-layout-full-size-header").should(new WebElementCondition[]{Condition.exist});
                break;
            }
            case fullSizeSidebar: {
                this.element().$(".n2o-layout-full-size-sidebar").should(new WebElementCondition[]{Condition.exist});
            }
        }
    }

    @Override
    public void shouldHaveError(int statusCode) {
        switch (statusCode) {
            case 404: {
                this.element().shouldHave(new WebElementCondition[]{Condition.text((String)"404\n\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")});
                break;
            }
            case 500: {
                this.element().shouldHave(new WebElementCondition[]{Condition.text((String)"500\n\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f")});
                break;
            }
            case 502: {
                this.element().shouldHave(new WebElementCondition[]{Condition.text((String)"502\n\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 \u043e\u0442 \u0432\u043e\u0441\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430")});
                break;
            }
            case 403: {
                this.element().shouldHave(new WebElementCondition[]{Condition.text((String)"403\n\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d")});
                break;
            }
            default: {
                this.element().$(".n2o-alert-segment").shouldHave(new WebElementCondition[]{Condition.text((String)String.valueOf(statusCode))});
            }
        }
    }

    protected SelenideElement body() {
        return this.element().$(".n2o-page-body");
    }

    public class N2oPageToolbar
    implements Page.PageToolbar {
        private static final String TOOLBAR = ".n2o-page-body .toolbar_placement_%s .btn";

        @Override
        public Toolbar topLeft() {
            return N2oSelenide.collection(N2oPage.this.element().$$(String.format(TOOLBAR, "topLeft")), Toolbar.class);
        }

        @Override
        public Toolbar topRight() {
            return N2oSelenide.collection(N2oPage.this.element().$$(String.format(TOOLBAR, "topRight")), Toolbar.class);
        }

        @Override
        public Toolbar bottomLeft() {
            return N2oSelenide.collection(N2oPage.this.element().$$(String.format(TOOLBAR, "bottomLeft")), Toolbar.class);
        }

        @Override
        public Toolbar bottomRight() {
            return N2oSelenide.collection(N2oPage.this.element().$$(String.format(TOOLBAR, "bottomRight")), Toolbar.class);
        }
    }

    public class N2oBreadcrumb
    extends N2oComponent
    implements Page.Breadcrumb {
        public N2oBreadcrumb(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public void shouldHaveSize(int size) {
            this.crumbs().should(new WebElementsCondition[]{CollectionCondition.size((int)size)});
        }

        @Override
        public N2oCrumb crumb(int index) {
            return new N2oCrumb(this.crumbs().get(index));
        }

        @Override
        public N2oCrumb crumb(String label) {
            return new N2oCrumb(this.crumbs().findBy(Condition.text((String)label)));
        }

        private ElementsCollection crumbs() {
            return this.element().$$(".breadcrumb-item");
        }

        public class N2oCrumb
        extends N2oComponent
        implements Page.Breadcrumb.Crumb {
            public N2oCrumb(SelenideElement element) {
                this.setElement(element);
            }

            @Override
            public void click() {
                this.element().click();
            }

            @Override
            public void shouldHaveLabel(String text, Duration ... duration) {
                this.should(Condition.text((String)text), this.element().lastChild(), duration);
            }

            @Override
            public void shouldHaveLink(String link) {
                this.breadcrumbLink().shouldHave(new WebElementCondition[]{Condition.href((String)link)});
            }

            @Override
            public void shouldNotHaveLink() {
                this.breadcrumbLink().shouldNot(new WebElementCondition[]{Condition.exist});
            }

            protected SelenideElement breadcrumbLink() {
                return this.element().$(".n2o-breadcrumb-link");
            }
        }
    }

    public class N2oOverlay
    extends N2oComponent
    implements Page.Overlay {
        private static final String TOOLBAR = ".toolbar-container .btn";

        @Override
        public Toolbar toolbar() {
            return N2oSelenide.collection(this.element().$$(TOOLBAR), Toolbar.class);
        }

        public N2oOverlay(SelenideElement element) {
            this.setElement(element);
        }
    }

    public static class N2oDialog
    extends N2oComponent
    implements Page.Dialog {
        public N2oDialog(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public void shouldHaveText(String text, Duration ... duration) {
            this.should(Condition.text((String)text), this.element().$(".modal-body"), duration);
        }

        @Override
        public StandardButton button(String label) {
            return N2oSelenide.component(this.element().$$(".btn").findBy(Condition.text((String)label)), StandardButton.class);
        }

        @Override
        public StandardButton button(int index) {
            return N2oSelenide.component(this.element().$$(".btn").get(index), StandardButton.class);
        }

        @Override
        public void shouldBeClosed(long timeOut) {
            SelenideElement modalTitle = this.element().$(".modal-header .modal-title");
            if (modalTitle.exists()) {
                modalTitle.shouldNotBe(Condition.exist, Duration.ofMillis(timeOut));
            }
        }

        @Override
        public void shouldHaveReversedButtons() {
            this.element().$(".btn-group").shouldHave(new WebElementCondition[]{Condition.cssClass((String)"flex-row-reverse")});
        }
    }

    public static class N2oPopover
    extends N2oComponent
    implements Page.Popover {
        public N2oPopover(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public void shouldHaveText(String text, Duration ... duration) {
            this.should(Condition.text((String)text), this.popoverBody(), duration);
        }

        @Override
        public StandardButton button(String label) {
            return N2oSelenide.component(this.element().shouldBe(new WebElementCondition[]{Condition.exist}).$$(".popover-body .btn").findBy(Condition.exactText((String)label)), StandardButton.class);
        }

        @Override
        public StandardButton button(int index) {
            return N2oSelenide.component(this.element().shouldBe(new WebElementCondition[]{Condition.exist}).$$(".popover-body .btn").get(index), StandardButton.class);
        }

        @Override
        public void shouldBeClosed(Duration ... duration) {
            this.should(Condition.not((WebElementCondition)Condition.exist), this.popoverBody(), duration);
        }

        private SelenideElement popoverBody() {
            return this.element().$(".popover-body");
        }
    }

    static class UrlMatch
    extends WebElementCondition {
        private final String regex;

        public UrlMatch(String regex) {
            super("urlMatch", true);
            this.regex = regex;
        }

        @Nonnull
        public CheckResult check(Driver driver, @Nonnull WebElement element) {
            boolean result = driver.url().matches(this.regex);
            return new CheckResult(result ? CheckResult.Verdict.ACCEPT : CheckResult.Verdict.REJECT, null);
        }

        @Nonnull
        public String toString() {
            return String.format("%s '%s'", this.getName(), this.regex);
        }
    }
}

