/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.modal;

import com.codeborne.selenide.ClickOptions;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.collection.Toolbar;
import net.n2oapp.framework.autotest.api.component.modal.Modal;
import net.n2oapp.framework.autotest.api.component.page.Page;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public class N2oModal
extends N2oComponent
implements Modal {
    private static final String MODAL_BODY = ".modal-body";
    private static final String MODAL_DIALOG_SCROLLABLE = ".modal-dialog-scrollable";
    private static final String MODAL_HEADER = ".modal-header";

    @Override
    public void shouldHaveTitle(String text, Duration ... duration) {
        this.should(Condition.text((String)text), this.element().$(".modal-header .modal-title, .white-space-pre-line"), duration);
    }

    @Override
    public void shouldNotHaveHeader() {
        this.element().$(MODAL_HEADER).shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public Modal.ModalToolbar toolbar() {
        return new N2oModalToolbar();
    }

    @Override
    public <T extends Page> T content(Class<T> pageClass) {
        return (T)((Page)N2oSelenide.component(this.element().$(MODAL_BODY), pageClass));
    }

    @Override
    public void scrollUp() {
        Selenide.executeJavaScript((String)String.format("document.querySelector('%s').scrollTop = 0", MODAL_BODY), (Object[])new Object[0]);
    }

    @Override
    public void scrollDown() {
        Selenide.executeJavaScript((String)String.format("document.querySelector('%s').scrollTop = document.querySelector('%s').scrollHeight", MODAL_BODY, MODAL_BODY), (Object[])new Object[0]);
    }

    @Override
    public void shouldBeScrollable() {
        this.element().$(String.format("%s %s", MODAL_DIALOG_SCROLLABLE, MODAL_BODY)).should(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotBeScrollable() {
        this.element().$(String.format("%s %s", MODAL_DIALOG_SCROLLABLE, MODAL_BODY)).shouldNot(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void close() {
        this.element().$(String.format("%s [aria-label=\"Close\"]", MODAL_HEADER)).click();
    }

    @Override
    public void closeByEsc() {
        this.element().parent().parent().pressEscape();
    }

    @Override
    public void clickBackdrop() {
        int widthOffset = this.element().getSize().getWidth() / 2 + 10;
        this.element().click(ClickOptions.usingDefaultMethod().offsetX(widthOffset));
    }

    public class N2oModalToolbar
    implements Modal.ModalToolbar {
        @Override
        public Toolbar bottomLeft() {
            return N2oSelenide.collection(N2oModal.this.element().$$(".modal-footer .n2o-modal-actions .toolbar_placement_bottomLeft .btn"), Toolbar.class);
        }

        @Override
        public Toolbar bottomRight() {
            return N2oSelenide.collection(N2oModal.this.element().$$(".modal-footer .n2o-modal-actions .toolbar_placement_bottomRight .btn"), Toolbar.class);
        }
    }
}

