/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.header;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ShapeType;
import net.n2oapp.framework.autotest.api.component.header.MenuItem;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public abstract class N2oMenuItem
extends N2oComponent
implements MenuItem {
    @Override
    public void shouldHaveImage() {
        this.image().shouldHave(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void imageShouldHaveSrc(String src) {
        this.image().shouldHave(new WebElementCondition[]{Condition.attribute((String)"src", (String)src)});
    }

    @Override
    public void imageShouldHaveShape(ShapeType shape) {
        switch (shape) {
            case SQUARE: {
                this.checkShape("mr-2 n2o-nav-image ");
                break;
            }
            case ROUNDED: {
                this.checkShape(String.format("mr-2 n2o-nav-image %s", shape.getId()));
                break;
            }
            case CIRCLE: {
                this.checkShape(String.format("mr-2 n2o-nav-image rounded-%s", shape.getId()));
            }
        }
    }

    @Override
    public void shouldHaveLabel(String text, Duration ... duration) {
        this.should(Condition.text((String)text), duration);
    }

    @Override
    public void click() {
        this.element().shouldBe(new WebElementCondition[]{Condition.exist}).click();
    }

    private void checkShape(String shape) {
        this.image().shouldHave(new WebElementCondition[]{Condition.attribute((String)"class", (String)shape)});
    }

    protected SelenideElement image() {
        return this.element().$("img");
    }
}

