/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.header;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.BadgePosition;
import net.n2oapp.framework.autotest.api.component.header.AnchorMenuItem;
import net.n2oapp.framework.autotest.impl.component.header.N2oMenuItem;

public class N2oAnchorMenuItem
extends N2oMenuItem
implements AnchorMenuItem {
    @Override
    public void shouldHaveIcon() {
        this.icon().shouldHave(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveIconCssClass(String cssClass) {
        this.icon().shouldHave(new WebElementCondition[]{Condition.attributeMatching((String)"class", (String)String.format(".*%s", cssClass))});
    }

    @Override
    public void shouldHaveBadge() {
        this.badge().shouldHave(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveBadgeText(String text, Duration ... duration) {
        this.should(Condition.text((String)text), this.badge(), duration);
    }

    @Override
    public void shouldHaveBadgeColor(String color) {
        this.badge().shouldHave(new WebElementCondition[]{Condition.cssClass((String)String.format("badge-%s", color))});
    }

    @Override
    public void badgeShouldHavePosition(BadgePosition position) {
        if (position.equals((Object)BadgePosition.LEFT)) {
            this.element().$(".n2o-badge-container").shouldHave(new WebElementCondition[]{Condition.cssClass((String)"flex-row-reverse")});
        } else {
            this.element().$(".n2o-badge-container").shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)"flex-row-reverse")});
        }
    }

    @Override
    public void shouldHaveUrl(String url) {
        this.element().$("a").shouldHave(new WebElementCondition[]{Condition.attribute((String)"href", (String)url)});
    }

    @Override
    public void shouldNotBeClickable() {
        if (this.element().is(Condition.tagName((String)"button"))) {
            this.element().$("li.nav_item").shouldHave(new WebElementCondition[]{Condition.cssClass((String)"static-menu-item")});
        } else {
            this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"static-menu-item")});
        }
    }

    protected SelenideElement icon() {
        return this.element().$("i");
    }

    protected SelenideElement badge() {
        return this.element().$(".badge");
    }
}

