/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.drawer;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import javax.annotation.Nonnull;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.collection.Toolbar;
import net.n2oapp.framework.autotest.api.component.drawer.Drawer;
import net.n2oapp.framework.autotest.api.component.page.Page;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;
import org.openqa.selenium.WebElement;

public class N2oDrawer
extends N2oComponent
implements Drawer {
    @Override
    public <T extends Page> T content(Class<T> pageClass) {
        return (T)((Page)N2oSelenide.component(this.element().$(".drawer-content .n2o-page-body"), pageClass));
    }

    @Override
    public Drawer.DrawerToolbar toolbar() {
        return new N2oDrawerToolbar();
    }

    @Override
    public void shouldHaveTitle(String text, Duration ... duration) {
        this.should(Condition.text((String)text), this.element().$(".drawer-title"), duration);
    }

    @Override
    public void shouldHavePlacement(Drawer.Placement placement) {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)("drawer-" + placement.name()))});
    }

    @Override
    public void shouldHaveWidth(String width) {
        this.element().$(".drawer-content-wrapper").shouldHave(new WebElementCondition[]{new StyleAttribute("width", width)});
    }

    @Override
    public void shouldHaveHeight(String height) {
        this.element().$(".drawer-content-wrapper").shouldHave(new WebElementCondition[]{new StyleAttribute("height", height)});
    }

    @Override
    public void close() {
        this.element().$(".drawer-handle").click();
    }

    @Override
    public void closeByEsc() {
        this.element().pressEscape();
    }

    @Override
    public void clickBackdrop() {
        this.element().click();
    }

    @Override
    public void shouldHaveFixedFooter() {
        this.getFooter().shouldBe(new WebElementCondition[]{Condition.cssClass((String)"drawer-footer--fixed")});
    }

    @Override
    public void shouldNotHaveFixedFooter() {
        this.getFooter().shouldNotBe(new WebElementCondition[]{Condition.cssClass((String)"drawer-footer--fixed")});
    }

    @Override
    public void scrollUp() {
        Selenide.executeJavaScript((String)"document.querySelector('.n2o-drawer-children-wrapper').scrollTop = 0", (Object[])new Object[0]);
    }

    @Override
    public void scrollDown() {
        Selenide.executeJavaScript((String)"document.querySelector('.n2o-drawer-children-wrapper').scrollTop = document.querySelector('.n2o-drawer-children-wrapper').scrollHeight", (Object[])new Object[0]);
    }

    protected SelenideElement getFooter() {
        return this.element().$(".drawer-footer");
    }

    public class N2oDrawerToolbar
    implements Drawer.DrawerToolbar {
        @Override
        public Toolbar bottomLeft() {
            return N2oSelenide.collection(N2oDrawer.this.element().$$(".drawer-footer .n2o-modal-actions .toolbar_placement_bottomLeft .btn"), Toolbar.class);
        }

        @Override
        public Toolbar bottomRight() {
            return N2oSelenide.collection(N2oDrawer.this.element().$$(".drawer-footer .n2o-modal-actions .toolbar_placement_bottomRight .btn"), Toolbar.class);
        }
    }

    static class StyleAttribute
    extends WebElementCondition {
        private final String attributeName;
        private final String expectedAttributeValue;

        StyleAttribute(String attributeName, String expectedAttributeValue) {
            super("attribute");
            this.attributeName = attributeName;
            this.expectedAttributeValue = expectedAttributeValue;
        }

        @Nonnull
        public CheckResult check(@Nonnull Driver driver, @Nonnull WebElement element) {
            boolean result = this.getAttributeValue(element).contains(this.attributeName + ": " + this.expectedAttributeValue);
            return new CheckResult(result ? CheckResult.Verdict.ACCEPT : CheckResult.Verdict.REJECT, null);
        }

        @Nonnull
        public String toString() {
            return String.format("attribute style contains %s: %s", this.attributeName, this.expectedAttributeValue);
        }

        private String getAttributeValue(WebElement element) {
            String attr = element.getAttribute("style");
            return attr == null ? "" : attr;
        }
    }
}

