/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.DropDown;
import net.n2oapp.framework.autotest.api.component.control.Select;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oSelect
extends N2oControl
implements Select {
    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        this.shouldSelected(value, duration);
    }

    @Override
    public void shouldBeEmpty() {
        this.selectedItemsContainer().shouldBe(new WebElementCondition[]{Condition.empty});
    }

    @Override
    public void setValue(String value) {
        this.selectedItemsContainer().$(".input").setValue(value);
    }

    @Override
    public void pressEnter() {
        this.element().parent().pressEnter();
    }

    @Override
    public void click() {
        this.selectedItemsContainer().click();
    }

    @Override
    public void shouldSelected(String value, Duration ... duration) {
        this.should(Condition.value((String)value), this.selectedItemsContainer().$(".valueText"), duration);
    }

    @Override
    public void shouldSelected(int count, Duration ... duration) {
        this.should(Condition.value((String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 %d \u0448\u0442", count)), this.selectedItemsContainer().$(".valueText"), duration);
    }

    @Override
    public void clear() {
        this.clearIcon().hover().shouldBe(new WebElementCondition[]{Condition.visible}).click();
    }

    @Override
    public void shouldBeCleanable() {
        this.clearIcon().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotBeCleanable() {
        this.clearIcon().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldBeDisabled() {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"disabled")});
    }

    @Override
    public void openPopup() {
        SelenideElement popupIcon = this.popupIcon();
        if (!popupIcon.is(Condition.cssClass((String)"isExpanded"))) {
            popupIcon.click();
        }
    }

    @Override
    public void closePopup() {
        SelenideElement popupIcon = this.popupIcon();
        if (popupIcon.is(Condition.cssClass((String)"isExpanded"))) {
            popupIcon.click();
        }
    }

    @Override
    public void shouldBeOpened() {
        this.selectPopUp().shouldNotBe(new WebElementCondition[]{Condition.hidden});
    }

    @Override
    public void shouldBeClosed() {
        this.selectPopUp().shouldBe(new WebElementCondition[]{Condition.hidden});
    }

    @Override
    public DropDown dropdown() {
        return N2oSelenide.component(this.element().parent().parent().$(".n2o-dropdown-control"), DropDown.class);
    }

    protected SelenideElement selectPopUp() {
        return this.element().parent().parent().$(".n2o-select-pop-up");
    }

    protected SelenideElement popupIcon() {
        return this.element().$(".n2o-popup-control");
    }

    protected SelenideElement clearIcon() {
        return this.element().$(".n2o-input-clear");
    }

    protected SelenideElement selectedItemsContainer() {
        return this.element().$(".n2o-input-items");
    }
}

