/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.RadioGroup;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oRadioGroup
extends N2oControl
implements RadioGroup {
    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        this.shouldBeChecked(value, duration);
    }

    @Override
    public void shouldBeEmpty() {
        this.element().$(".checked").shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldBeChecked(String label, Duration ... duration) {
        this.should(Condition.text((String)label), this.element().$(".checked span"), duration);
    }

    @Override
    public void check(String label) {
        this.element().$$("span").findBy(Condition.text((String)label)).click();
    }

    @Override
    public void shouldHaveOptions(String[] labels, Duration ... duration) {
        this.should(CollectionCondition.exactTexts((String[])labels), this.radioInput(), duration);
    }

    @Override
    public void shouldNotHaveOptions(Duration ... duration) {
        this.should(CollectionCondition.size((int)0), this.radioInput(), duration);
    }

    @Override
    public void shouldHaveType(RadioGroup.RadioType type) {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)String.format("n2o-radio-group-%s", type.name().toLowerCase()))});
    }

    @Override
    public void shouldBeDisabled() {
        this.radioInput().asFixedIterable().stream().forEach(el -> el.parent().$(".n2o-input").shouldBe(new WebElementCondition[]{Condition.disabled}));
    }

    @Override
    public void shouldBeUnchecked(String label, Duration ... duration) {
        this.should(Condition.or((String)"", (WebElementCondition)Condition.not((WebElementCondition)Condition.exist), (WebElementCondition)Condition.not((WebElementCondition)Condition.text((String)label)), (WebElementCondition[])new WebElementCondition[0]), this.element().$(".checked span"), duration);
    }

    protected ElementsCollection radioInput() {
        return this.element().$$(".n2o-radio-input");
    }
}

