/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.NumberPicker;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oNumberPicker
extends N2oControl
implements NumberPicker {
    @Override
    public void shouldBeEmpty() {
        this.inputElement().shouldBe(new WebElementCondition[]{Condition.empty});
    }

    @Override
    public void setValue(String value) {
        this.inputElement().setValue(value).pressTab();
    }

    @Override
    public void click() {
        this.inputElement().click();
    }

    @Override
    public void clear() {
        this.inputElement().clear();
        this.inputElement().pressTab();
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        WebElementCondition condition = value == null || value.isEmpty() ? Condition.empty : Condition.value((String)value);
        this.should(condition, this.inputElement(), duration);
    }

    @Override
    public void clickPlusStepButton() {
        this.plusButton().click();
    }

    @Override
    public void minusStepButtonShouldBeEnabled() {
        this.minusButton().parent().shouldBe(new WebElementCondition[]{Condition.enabled});
    }

    @Override
    public void minusStepButtonShouldBeDisabled() {
        this.minusButton().parent().shouldBe(new WebElementCondition[]{Condition.disabled});
    }

    @Override
    public void shouldBeDisabled() {
        this.inputElement().shouldBe(new WebElementCondition[]{Condition.disabled});
    }

    @Override
    public void clickMinusStepButton() {
        this.minusButton().click();
    }

    @Override
    public void plusStepButtonShouldBeEnabled() {
        this.plusButton().parent().shouldBe(new WebElementCondition[]{Condition.enabled});
    }

    @Override
    public void plusStepButtonShouldBeDisabled() {
        this.plusButton().parent().shouldBe(new WebElementCondition[]{Condition.disabled});
    }

    @Override
    public void shouldHaveMin(String min) {
        this.inputElement().shouldBe(new WebElementCondition[]{Condition.attribute((String)"min", (String)min)});
    }

    @Override
    public void shouldHaveMax(String max) {
        this.inputElement().shouldBe(new WebElementCondition[]{Condition.attribute((String)"max", (String)max)});
    }

    @Override
    public void shouldHaveStep(String step) {
        this.inputElement().shouldBe(new WebElementCondition[]{Condition.attribute((String)"step", (String)step)});
    }

    protected SelenideElement inputElement() {
        this.element().shouldBe(new WebElementCondition[]{Condition.exist});
        return this.element().parent().$(".n2o-number-picker__input");
    }

    protected SelenideElement minusButton() {
        return this.element().parent().$(".n2o-number-picker__button .fa-minus");
    }

    protected SelenideElement plusButton() {
        return this.element().parent().$(".n2o-number-picker__button .fa-plus");
    }
}

