/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.InputText;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oInputText
extends N2oControl
implements InputText {
    @Override
    public void shouldBeEmpty() {
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            input.shouldBe(new WebElementCondition[]{Condition.empty});
        } else {
            this.editCellElement().shouldBe(new WebElementCondition[]{Condition.empty});
        }
    }

    @Override
    public String getValue() {
        SelenideElement input = this.inputElement();
        return input.exists() ? input.getValue() : this.editCellElement().text();
    }

    @Override
    public void setValue(String value) {
        if (this.editCellInputElement().exists()) {
            this.editCellInputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), value});
            this.editCellInputElement().pressEnter();
        } else {
            this.inputElement().setValue(value);
        }
    }

    @Override
    public void pressEnter() {
        this.inputElement().pressEnter();
    }

    @Override
    public void click() {
        this.inputElement().click();
    }

    @Override
    public void clear() {
        this.inputElement().clear();
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            this.should(Condition.exactValue((String)value), input, duration);
        } else {
            this.should(Condition.text((String)value), this.editCellElement(), duration);
        }
    }

    @Override
    public void shouldHavePlaceholder(String placeholder) {
        WebElementCondition condition = Condition.attribute((String)"placeholder", (String)placeholder);
        SelenideElement input = this.inputElement();
        if (input.exists()) {
            input.shouldHave(new WebElementCondition[]{condition});
        } else {
            this.editCellElement().shouldHave(new WebElementCondition[]{condition});
        }
    }

    @Override
    public void clickPlusStepButton() {
        this.stepButton().get(0).click();
    }

    @Override
    public void clickMinusStepButton() {
        this.stepButton().get(1).click();
    }

    @Override
    public void shouldHaveMeasure() {
        this.inputMeasure().should(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveMeasureText(String text, Duration ... duration) {
        this.should(Condition.text((String)text), this.inputMeasure(), duration);
    }

    protected ElementsCollection stepButton() {
        return this.element().parent().$$(".n2o-input-number-buttons button");
    }

    protected SelenideElement inputElement() {
        return this.element().shouldBe(new WebElementCondition[]{Condition.exist}).parent().$(".n2o-input");
    }

    protected SelenideElement editCellInputElement() {
        return this.element().$(".n2o-advanced-table-edit-control");
    }

    protected SelenideElement editCellElement() {
        return this.element().$(".n2o-editable-cell .n2o-editable-cell-text");
    }

    protected SelenideElement inputMeasure() {
        SelenideElement elm = this.element().parent();
        if (elm.is(Condition.cssClass((String)"n2o-input-number"))) {
            elm = elm.parent();
        }
        return elm.$(".n2o-control-container-placeholder");
    }
}

