/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import java.util.Arrays;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.DropDown;
import net.n2oapp.framework.autotest.api.component.control.InputSelect;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oInputSelect
extends N2oControl
implements InputSelect {
    @Override
    public void click() {
        this.element().$(".n2o-input-items").click();
    }

    @Override
    public void setValue(String value) {
        this.input().setValue(value);
    }

    @Override
    public void setMultiValue(String ... values) {
        Arrays.stream(values).forEach(s -> this.input().setValue(s).pressEnter());
    }

    @Override
    public void pressEnter() {
        this.input().pressEnter();
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        if (this.input().exists()) {
            this.should(Condition.value((String)value), this.input(), duration);
        } else {
            this.should(Condition.text((String)value), this.cellInputElement(), duration);
        }
    }

    @Override
    public void shouldHaveDropdownMessage(String value, Duration ... duration) {
        this.should(Condition.exactText((String)value), this.element().parent().parent().parent().$(".n2o-dropdown-control"), duration);
    }

    protected SelenideElement cellInputElement() {
        return this.element().$(".n2o-editable-cell .n2o-editable-cell-text");
    }

    @Override
    public void shouldSelectedMulti(String[] values, Duration ... duration) {
        if (values.length != 0) {
            this.should(CollectionCondition.size((int)values.length), this.selectedItems(), duration);
            this.should(CollectionCondition.textsInAnyOrder((String[])values), this.selectedItems(), duration);
        }
    }

    @Override
    public void shouldSelectedMultiSize(int size) {
        this.selectedItems().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)size)});
    }

    @Override
    public void clearUsingIcon() {
        this.element().$(".n2o-input-clear").hover().shouldBe(new WebElementCondition[]{Condition.visible}).click();
    }

    @Override
    public void clear() {
        this.input().clear();
    }

    @Override
    public void shouldBeEmpty() {
        this.input().shouldBe(new WebElementCondition[]{Condition.empty});
        if (this.isMulti()) {
            this.input().parent().$(".selected-item").shouldNot(new WebElementCondition[]{Condition.exist});
        }
    }

    @Override
    public void clearItems(String ... items) {
        ElementsCollection selectedItems = this.selectedItems();
        Arrays.stream(items).forEach(s -> selectedItems.find(Condition.text((String)s)).$("button").click());
    }

    @Override
    public void shouldBeDisabled() {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"disabled")});
    }

    @Override
    public void openPopup() {
        SelenideElement popupIcon = this.popupIcon();
        if (!popupIcon.is(Condition.cssClass((String)"isExpanded"))) {
            popupIcon.click();
        }
    }

    @Override
    public void closePopup() {
        SelenideElement popupIcon = this.popupIcon();
        if (popupIcon.is(Condition.cssClass((String)"isExpanded"))) {
            popupIcon.click();
        }
    }

    @Override
    public void shouldBeOpened() {
        this.selectPopUp().shouldNotBe(new WebElementCondition[]{Condition.hidden});
    }

    @Override
    public void shouldBeClosed() {
        this.selectPopUp().shouldBe(new WebElementCondition[]{Condition.hidden});
    }

    @Override
    public DropDown dropdown() {
        return N2oSelenide.component(this.element().parent().parent().$(".n2o-dropdown-control"), DropDown.class);
    }

    @Override
    public void backspace() {
        this.input().sendKeys(new CharSequence[]{Keys.BACK_SPACE});
    }

    protected SelenideElement popupIcon() {
        return this.element().$(".n2o-popup-control");
    }

    protected ElementsCollection selectedItems() {
        return this.element().$$(".selected-item");
    }

    protected SelenideElement input() {
        return this.element().$(".n2o-inp");
    }

    protected SelenideElement selectPopUp() {
        return this.element().parent().parent().$(".n2o-pop-up");
    }

    private boolean isMulti() {
        return this.input().has(Condition.cssClass((String)"n2o-inp--multi"));
    }
}

