/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.io.File;
import java.time.Duration;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ShapeType;
import net.n2oapp.framework.autotest.api.component.control.ImageUploadControl;
import net.n2oapp.framework.autotest.api.component.page.Page;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oImageUploadControl
extends N2oControl
implements ImageUploadControl {
    private static final String UPLOAD_SHAPE_CLASS = "n2o-image-uploader-control--shape-";

    @Override
    public void shouldBeEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File uploadImage(File ... image) {
        return this.element().$("input").uploadFile(image);
    }

    @Override
    public File uploadFromClasspath(String ... imageName) {
        return this.element().$("input").uploadFromClasspath(imageName);
    }

    @Override
    public void shouldHaveDeleteButton(int index) {
        this.getTrashElement(index).shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotHaveDeleteButton(int index) {
        this.getTrashElement(index).shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void deleteImage(int index) {
        this.getTrashElement(index).hover().shouldBe(new WebElementCondition[]{Condition.visible}).click();
    }

    @Override
    public void shouldHavePreview(int index) {
        this.getPreviewElement(index).shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotHavePreview(int index) {
        this.getPreviewElement(index).shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public ImageUploadControl.PreviewDialog openPreviewDialog(Page page, int index) {
        this.getPreviewElement(index).hover().shouldBe(new WebElementCondition[]{Condition.visible}).click();
        return new PreviewDialogImpl(page);
    }

    @Override
    public void shouldHaveSize(int size) {
        this.getFilesItems().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)size)});
    }

    @Override
    public void shouldHaveNameInfo(int index) {
        this.getNameElement(index).shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotHaveNameInfo(int index) {
        this.getNameElement(index).shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldHaveName(int index, String fileName, Duration ... duration) {
        this.should(Condition.text((String)fileName), this.getNameElement(index), duration);
    }

    @Override
    public void shouldHaveVisibleSizeInfo(int index) {
        this.getSizeElement(index).shouldBe(new WebElementCondition[]{Condition.visible});
    }

    @Override
    public void shouldNotHaveVisibleSizeInfo(int index) {
        this.getSizeElement(index).shouldNotBe(new WebElementCondition[]{Condition.visible});
    }

    @Override
    public void shouldHaveSize(int index, String fileSize) {
        this.getSizeElement(index).shouldHave(new WebElementCondition[]{Condition.text((String)fileSize)});
    }

    @Override
    public void uploadAreaShouldHaveShape(ShapeType shape) {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)String.format("%s%s", UPLOAD_SHAPE_CLASS, shape.getId()))});
    }

    @Override
    public void uploadAreaShouldHaveIcon(String icon) {
        this.getUploadAreaElement().shouldHave(new WebElementCondition[]{Condition.attribute((String)"class", (String)icon)});
    }

    @Override
    public void uploadAreaShouldHaveIconSize(int size) {
        this.getUploadAreaElement().shouldHave(new WebElementCondition[]{Condition.attributeMatching((String)"style", (String)String.format(".*font-size: %dpx.*", size))});
    }

    @Override
    public void uploadAreaShouldHaveWidth(int width) {
        this.element().shouldHave(new WebElementCondition[]{Condition.attributeMatching((String)"style", (String)String.format(".*max-width: %dpx.*", width))});
    }

    @Override
    public void uploadAreaShouldHaveHeight(int height) {
        this.element().shouldHave(new WebElementCondition[]{Condition.attributeMatching((String)"style", (String)String.format(".*max-height: %dpx.*", height))});
    }

    @Override
    public void shouldBeDisabled() {
        this.element().$("input").shouldBe(new WebElementCondition[]{Condition.disabled});
    }

    protected ElementsCollection getFilesItems() {
        return this.element().parent().$$(".n2o-file-uploader-files-item-info");
    }

    protected SelenideElement getPreviewElement(int index) {
        return this.getFilesItems().get(index).$(".n2o-image-uploader__watch .n2o-image-uploader__watch--eye");
    }

    protected SelenideElement getNameElement(int index) {
        return this.getFilesItems().get(index).$(".n2o-image-uploader-img-info .n2o-image-uploader-img-info__file-name");
    }

    protected SelenideElement getSizeElement(int index) {
        return this.getFilesItems().get(index).$(".n2o-image-uploader-img-info .n2o-image-uploader-img-info__file-size");
    }

    protected SelenideElement getUploadAreaElement() {
        return this.element().$("div");
    }

    protected SelenideElement getTrashElement(int index) {
        return this.getFilesItems().get(index).$(".n2o-image-uploader__watch .n2o-image-uploader__watch--trash");
    }

    public static class PreviewDialogImpl
    implements ImageUploadControl.PreviewDialog {
        private final SelenideElement element;

        public PreviewDialogImpl(Page page) {
            this.element = page.element().$(".n2o-image-uploader__modal--body");
        }

        @Override
        public void shouldExists() {
            this.element.should(new WebElementCondition[]{Condition.exist});
        }

        @Override
        public void shouldHaveLink(String link) {
            this.element.$(".n2o-image-uploader__modal--image").shouldHave(new WebElementCondition[]{Condition.attribute((String)"src", (String)link)});
        }

        @Override
        public void close() {
            this.element.$(".n2o-image-uploader__modal--icon-close").click();
        }
    }
}

