/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.control.DateInterval;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oDateInterval
extends N2oControl
implements DateInterval {
    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shouldBeEmpty() {
        this.beginShouldBeEmpty();
        this.endShouldBeEmpty();
    }

    @Override
    public void beginShouldBeEmpty() {
        this.firstInputElement().shouldBe(new WebElementCondition[]{Condition.empty});
    }

    @Override
    public void endShouldBeEmpty() {
        this.lastInputElement().shouldBe(new WebElementCondition[]{Condition.empty});
    }

    @Override
    public void setValueInBegin(String value) {
        this.firstInputElement().setValue(value);
        this.element().click();
    }

    @Override
    public void setValueInEnd(String value) {
        this.lastInputElement().setValue(value);
        this.element().click();
    }

    @Override
    public void beginShouldHaveValue(String value, Duration ... duration) {
        WebElementCondition condition = value == null || value.isEmpty() ? Condition.empty : Condition.value((String)value);
        SelenideElement element = this.element().$(".n2o-date-input-first input");
        this.should(condition, element, duration);
    }

    @Override
    public void endShouldHaveValue(String value, Duration ... duration) {
        WebElementCondition condition = value == null || value.isEmpty() ? Condition.empty : Condition.value((String)value);
        SelenideElement element = this.element().$(".n2o-date-input-last input");
        this.should(condition, element, duration);
    }

    @Override
    public void clickCalendarButton() {
        this.lastInputElement().parent().$(".btn.n2o-calendar-button").shouldBe(new WebElementCondition[]{Condition.exist}).click();
    }

    @Override
    public void beginDayShouldBeActive(String day) {
        this.shouldBeActiveDay(this.firstCalendar(), day);
    }

    @Override
    public void endDayShouldBeActive(String day) {
        this.shouldBeActiveDay(this.lastCalendar(), day);
    }

    @Override
    public void beginDayShouldBeDisabled(String day) {
        this.shouldBeDisableDay(this.firstCalendar(), day);
    }

    @Override
    public void endDayShouldBeDisabled(String day) {
        this.shouldBeDisableDay(this.lastCalendar(), day);
    }

    @Override
    public void beginDayShouldBeEnabled(String day) {
        this.shouldBeEnableDay(this.firstCalendar(), day);
    }

    @Override
    public void endDayShouldBeEnabled(String day) {
        this.shouldBeEnableDay(this.lastCalendar(), day);
    }

    @Override
    public void clickBeginDay(String day) {
        this.clickDay(this.firstCalendar(), day);
    }

    @Override
    public void clickEndDay(String day) {
        this.clickDay(this.lastCalendar(), day);
    }

    @Override
    public void beginCurrentMonthShouldHaveValue(String month, Duration ... duration) {
        this.shouldHaveCurrentMonth(this.firstCalendar(), month, duration);
    }

    @Override
    public void endCurrentMonthShouldHaveValue(String month, Duration ... duration) {
        this.shouldHaveCurrentMonth(this.lastCalendar(), month, duration);
    }

    @Override
    public void beginCurrentYearShouldHaveValue(String year, Duration ... duration) {
        this.shouldHaveCurrentYear(this.firstCalendar(), year, duration);
    }

    @Override
    public void endCurrentYearShouldHaveValue(String year, Duration ... duration) {
        this.shouldHaveCurrentYear(this.lastCalendar(), year, duration);
    }

    @Override
    public void clickBeginMonthPreviousButton() {
        this.clickPreviousMonthButton(this.firstCalendar());
    }

    @Override
    public void clickEndMonthPreviousButton() {
        this.clickPreviousMonthButton(this.lastCalendar());
    }

    @Override
    public void clickBeginMonthNextButton() {
        this.clickNextMonthButton(this.firstCalendar());
    }

    @Override
    public void clickEndMonthNextButton() {
        this.clickNextMonthButton(this.lastCalendar());
    }

    @Override
    public void beginTimeSetValue(String hours, String minutes, String seconds) {
        this.setTimeValue(this.firstCalendar(), hours, minutes, seconds);
    }

    @Override
    public void endTimeSetValue(String hours, String minutes, String seconds) {
        this.setTimeValue(this.lastCalendar(), hours, minutes, seconds);
    }

    @Override
    public void openPopup() {
        this.element().$(".n2o-date-input").should(new WebElementCondition[]{Condition.exist}).click();
    }

    @Override
    public void closePopup() {
        throw new UnsupportedOperationException("Date pop-up cannot be closed without choosing the date");
    }

    @Override
    public void shouldBeClosed() {
        this.popUp().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldBeOpened() {
        this.popUp().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldBeEnabled() {
        this.firstInputElement().shouldBe(new WebElementCondition[]{Condition.enabled});
        this.lastInputElement().shouldBe(new WebElementCondition[]{Condition.enabled});
    }

    @Override
    public void shouldBeDisabled() {
        this.firstInputElement().shouldBe(new WebElementCondition[]{Condition.disabled});
        this.lastInputElement().shouldBe(new WebElementCondition[]{Condition.disabled});
    }

    @Override
    public void pressEnter() {
        this.lastInputElement().pressEnter();
    }

    protected SelenideElement firstInputElement() {
        return this.element().$(".n2o-date-input-first input");
    }

    protected SelenideElement lastInputElement() {
        return this.element().$(".n2o-date-input-last input");
    }

    protected SelenideElement firstCalendar() {
        return this.element().$$(".n2o-calendar").get(0);
    }

    protected SelenideElement lastCalendar() {
        return this.element().$$(".n2o-calendar").get(1);
    }

    protected SelenideElement popUp() {
        return this.element().parent().parent().$(".n2o-pop-up");
    }

    private void setTimeValue(SelenideElement element, String hours, String minutes, String seconds) {
        element.$(".n2o-calendar-time-container").click();
        element.$$(".n2o-pop-up .hour-picker .n2o-calendar-time-unit").find(Condition.text((String)hours)).click();
        element.$$(".n2o-pop-up .minute-picker .n2o-calendar-time-unit").find(Condition.text((String)minutes)).click();
        element.$$(".n2o-pop-up .second-picker .n2o-calendar-time-unit").find(Condition.text((String)seconds)).click();
        element.$$(".n2o-calendar-time-buttons button").find(Condition.text((String)"\u0412\u044b\u0431\u0440\u0430\u0442\u044c")).click();
    }

    private void shouldBeActiveDay(SelenideElement element, String day) {
        element.$(".n2o-calendar-day.selected").shouldBe(new WebElementCondition[]{Condition.exist}).shouldHave(new WebElementCondition[]{Condition.text((String)day)});
    }

    private void shouldBeDisableDay(SelenideElement element, String day) {
        element.$$(".n2o-calendar-day.disabled").find(Condition.text((String)day)).shouldBe(new WebElementCondition[]{Condition.exist});
    }

    private void shouldBeEnableDay(SelenideElement element, String day) {
        element.$$(".n2o-calendar-day.disabled").find(Condition.text((String)day)).shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    private void clickDay(SelenideElement element, String day) {
        ((ElementsCollection)((ElementsCollection)((ElementsCollection)element.$$(".n2o-calendar-day").filter(Condition.text((String)day))).exclude(Condition.cssClass((String)"disabled"))).exclude(Condition.cssClass((String)"other-month"))).get(0).shouldBe(new WebElementCondition[]{Condition.exist}).click();
    }

    private void shouldHaveCurrentMonth(SelenideElement element, String month, Duration ... duration) {
        this.should(Condition.text((String)month), element.$(".n2o-calendar-header-month-title"), duration);
    }

    private void shouldHaveCurrentYear(SelenideElement element, String year, Duration ... duration) {
        this.should(Condition.text((String)year), element.$(".n2o-calendar-header-year-title"), duration);
    }

    private void clickPreviousMonthButton(SelenideElement element) {
        element.$(".n2o-calendar-header .fa-angle-left").click();
    }

    private void clickNextMonthButton(SelenideElement element) {
        element.$(".n2o-calendar-header .fa-angle-right").click();
    }
}

